// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.SecurityPolicyPropertiesParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** SecurityPolicy association for AzureFrontDoor profile. */
@Fluent
public final class SecurityPolicyInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SecurityPolicyInner.class);

    /*
     * The json object that contains properties required to create a security
     * policy
     */
    @JsonProperty(value = "properties")
    private SecurityPolicyProperties innerProperties;

    /*
     * Read only system data
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get the innerProperties property: The json object that contains properties required to create a security policy.
     *
     * @return the innerProperties value.
     */
    private SecurityPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Read only system data.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the profileName property: The name of the profile which holds the security policy.
     *
     * @return the profileName value.
     */
    public String profileName() {
        return this.innerProperties() == null ? null : this.innerProperties().profileName();
    }

    /**
     * Get the parameters property: object which contains security policy parameters.
     *
     * @return the parameters value.
     */
    public SecurityPolicyPropertiesParameters parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    /**
     * Set the parameters property: object which contains security policy parameters.
     *
     * @param parameters the parameters value to set.
     * @return the SecurityPolicyInner object itself.
     */
    public SecurityPolicyInner withParameters(SecurityPolicyPropertiesParameters parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityPolicyProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning status.
     *
     * @return the provisioningState value.
     */
    public AfdProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the deploymentStatus property: The deploymentStatus property.
     *
     * @return the deploymentStatus value.
     */
    public DeploymentStatus deploymentStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentStatus();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
