/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SecretParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="CustomerCertificate")
public final class CustomerCertificateParameters
extends SecretParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CustomerCertificateParameters.class);
    @JsonProperty(value="secretSource", required=true)
    private ResourceReference secretSource;
    @JsonProperty(value="secretVersion")
    private String secretVersion;
    @JsonProperty(value="useLatestVersion")
    private Boolean useLatestVersion;
    @JsonProperty(value="subject", access=JsonProperty.Access.WRITE_ONLY)
    private String subject;
    @JsonProperty(value="expirationDate", access=JsonProperty.Access.WRITE_ONLY)
    private String expirationDate;
    @JsonProperty(value="certificateAuthority", access=JsonProperty.Access.WRITE_ONLY)
    private String certificateAuthority;
    @JsonProperty(value="subjectAlternativeNames")
    private List<String> subjectAlternativeNames;
    @JsonProperty(value="thumbprint", access=JsonProperty.Access.WRITE_ONLY)
    private String thumbprint;

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public CustomerCertificateParameters withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public CustomerCertificateParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    public Boolean useLatestVersion() {
        return this.useLatestVersion;
    }

    public CustomerCertificateParameters withUseLatestVersion(Boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public String expirationDate() {
        return this.expirationDate;
    }

    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public CustomerCertificateParameters withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.secretSource() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property secretSource in model CustomerCertificateParameters"));
        }
        this.secretSource().validate();
    }
}

