// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Unit of the usage. e.g. count. */
public final class ResourceUsageUnit extends ExpandableStringEnum<ResourceUsageUnit> {
    /** Static value count for ResourceUsageUnit. */
    public static final ResourceUsageUnit COUNT = fromString("count");

    /**
     * Creates or finds a ResourceUsageUnit from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ResourceUsageUnit.
     */
    @JsonCreator
    public static ResourceUsageUnit fromString(String name) {
        return fromString(name, ResourceUsageUnit.class);
    }

    /**
     * Gets known ResourceUsageUnit values.
     *
     * @return known ResourceUsageUnit values.
     */
    public static Collection<ResourceUsageUnit> values() {
        return values(ResourceUsageUnit.class);
    }
}
