/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SecretParameters;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="UrlSigningKey")
public final class UrlSigningKeyParameters
extends SecretParameters {
    @JsonProperty(value="keyId", required=true)
    private String keyId;
    @JsonProperty(value="secretSource", required=true)
    private ResourceReference secretSource;
    @JsonProperty(value="secretVersion")
    private String secretVersion;
    private static final ClientLogger LOGGER = new ClientLogger(UrlSigningKeyParameters.class);

    public String keyId() {
        return this.keyId;
    }

    public UrlSigningKeyParameters withKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public UrlSigningKeyParameters withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public UrlSigningKeyParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.keyId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property keyId in model UrlSigningKeyParameters"));
        }
        if (this.secretSource() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property secretSource in model UrlSigningKeyParameters"));
        }
        this.secretSource().validate();
    }
}

