/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.CustomDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.KeyVaultCertificateSourceParameters;
import com.azure.resourcemanager.cdn.models.MinimumTlsVersion;
import com.azure.resourcemanager.cdn.models.ProtocolType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="certificateSource")
@JsonTypeName(value="AzureKeyVault")
public final class UserManagedHttpsParameters
extends CustomDomainHttpsParameters {
    @JsonProperty(value="certificateSourceParameters", required=true)
    private KeyVaultCertificateSourceParameters certificateSourceParameters;
    private static final ClientLogger LOGGER = new ClientLogger(UserManagedHttpsParameters.class);

    public KeyVaultCertificateSourceParameters certificateSourceParameters() {
        return this.certificateSourceParameters;
    }

    public UserManagedHttpsParameters withCertificateSourceParameters(KeyVaultCertificateSourceParameters certificateSourceParameters) {
        this.certificateSourceParameters = certificateSourceParameters;
        return this;
    }

    @Override
    public UserManagedHttpsParameters withProtocolType(ProtocolType protocolType) {
        super.withProtocolType(protocolType);
        return this;
    }

    @Override
    public UserManagedHttpsParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.certificateSourceParameters() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property certificateSourceParameters in model UserManagedHttpsParameters"));
        }
        this.certificateSourceParameters().validate();
    }
}

