// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Parameters required for content load. */
@Fluent
public final class LoadParameters {
    /*
     * The path to the content to be loaded. Path should be a relative file URL of the origin.
     */
    @JsonProperty(value = "contentPaths", required = true)
    private List<String> contentPaths;

    /** Creates an instance of LoadParameters class. */
    public LoadParameters() {
    }

    /**
     * Get the contentPaths property: The path to the content to be loaded. Path should be a relative file URL of the
     * origin.
     *
     * @return the contentPaths value.
     */
    public List<String> contentPaths() {
        return this.contentPaths;
    }

    /**
     * Set the contentPaths property: The path to the content to be loaded. Path should be a relative file URL of the
     * origin.
     *
     * @param contentPaths the contentPaths value to set.
     * @return the LoadParameters object itself.
     */
    public LoadParameters withContentPaths(List<String> contentPaths) {
        this.contentPaths = contentPaths;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (contentPaths() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property contentPaths in model LoadParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LoadParameters.class);
}
