// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The MigrateResultProperties model. */
@Immutable
public final class MigrateResultProperties {
    /*
     * Arm resource id of the migrated profile
     */
    @JsonProperty(value = "migratedProfileResourceId", access = JsonProperty.Access.WRITE_ONLY)
    private ResourceReference migratedProfileResourceId;

    /** Creates an instance of MigrateResultProperties class. */
    public MigrateResultProperties() {
    }

    /**
     * Get the migratedProfileResourceId property: Arm resource id of the migrated profile.
     *
     * @return the migratedProfileResourceId value.
     */
    public ResourceReference migratedProfileResourceId() {
        return this.migratedProfileResourceId;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (migratedProfileResourceId() != null) {
            migratedProfileResourceId().validate();
        }
    }
}
