// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cdn.models.ProfileProvisioningState;
import com.azure.resourcemanager.cdn.models.ProfileResourceState;
import com.azure.resourcemanager.cdn.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** A profile is a logical grouping of endpoints that share the same settings. */
@Fluent
public final class ProfileInner extends Resource {
    /*
     * The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the
     * profile.
     */
    @JsonProperty(value = "sku", required = true)
    private Sku sku;

    /*
     * Kind of the profile. Used by portal to differentiate traditional CDN profile and new AFD profile.
     */
    @JsonProperty(value = "kind", access = JsonProperty.Access.WRITE_ONLY)
    private String kind;

    /*
     * Managed service identity (system assigned and/or user assigned identities).
     */
    @JsonProperty(value = "identity")
    private ManagedServiceIdentity identity;

    /*
     * The JSON object that contains the properties required to create a profile.
     */
    @JsonProperty(value = "properties")
    private ProfileProperties innerProperties;

    /*
     * Read only system data
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /** Creates an instance of ProfileInner class. */
    public ProfileInner() {
    }

    /**
     * Get the sku property: The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature
     * list and rate) of the profile.
     *
     * @return the sku value.
     */
    public Sku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature
     * list and rate) of the profile.
     *
     * @param sku the sku value to set.
     * @return the ProfileInner object itself.
     */
    public ProfileInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the kind property: Kind of the profile. Used by portal to differentiate traditional CDN profile and new AFD
     * profile.
     *
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Get the identity property: Managed service identity (system assigned and/or user assigned identities).
     *
     * @return the identity value.
     */
    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Managed service identity (system assigned and/or user assigned identities).
     *
     * @param identity the identity value to set.
     * @return the ProfileInner object itself.
     */
    public ProfileInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the innerProperties property: The JSON object that contains the properties required to create a profile.
     *
     * @return the innerProperties value.
     */
    private ProfileProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Read only system data.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /** {@inheritDoc} */
    @Override
    public ProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the resourceState property: Resource status of the profile.
     *
     * @return the resourceState value.
     */
    public ProfileResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    /**
     * Get the provisioningState property: Provisioning status of the profile.
     *
     * @return the provisioningState value.
     */
    public ProfileProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the extendedProperties property: Key-Value pair representing additional properties for profiles.
     *
     * @return the extendedProperties value.
     */
    public Map<String, String> extendedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().extendedProperties();
    }

    /**
     * Get the frontDoorId property: The Id of the frontdoor.
     *
     * @return the frontDoorId value.
     */
    public String frontDoorId() {
        return this.innerProperties() == null ? null : this.innerProperties().frontDoorId();
    }

    /**
     * Get the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin. When
     * timeout is reached, the request fails and returns.
     *
     * @return the originResponseTimeoutSeconds value.
     */
    public Integer originResponseTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().originResponseTimeoutSeconds();
    }

    /**
     * Set the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin. When
     * timeout is reached, the request fails and returns.
     *
     * @param originResponseTimeoutSeconds the originResponseTimeoutSeconds value to set.
     * @return the ProfileInner object itself.
     */
    public ProfileInner withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfileProperties();
        }
        this.innerProperties().withOriginResponseTimeoutSeconds(originResponseTimeoutSeconds);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sku() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property sku in model ProfileInner"));
        } else {
            sku().validate();
        }
        if (identity() != null) {
            identity().validate();
        }
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ProfileInner.class);
}
