// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Parameters required for profile upgrade. */
@Fluent
public final class ProfileUpgradeParameters {
    /*
     * Web Application Firewall (WAF) and security policy mapping for the profile upgrade
     */
    @JsonProperty(value = "wafMappingList", required = true)
    private List<ProfileChangeSkuWafMapping> wafMappingList;

    /** Creates an instance of ProfileUpgradeParameters class. */
    public ProfileUpgradeParameters() {
    }

    /**
     * Get the wafMappingList property: Web Application Firewall (WAF) and security policy mapping for the profile
     * upgrade.
     *
     * @return the wafMappingList value.
     */
    public List<ProfileChangeSkuWafMapping> wafMappingList() {
        return this.wafMappingList;
    }

    /**
     * Set the wafMappingList property: Web Application Firewall (WAF) and security policy mapping for the profile
     * upgrade.
     *
     * @param wafMappingList the wafMappingList value to set.
     * @return the ProfileUpgradeParameters object itself.
     */
    public ProfileUpgradeParameters withWafMappingList(List<ProfileChangeSkuWafMapping> wafMappingList) {
        this.wafMappingList = wafMappingList;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (wafMappingList() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property wafMappingList in model ProfileUpgradeParameters"));
        } else {
            wafMappingList().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ProfileUpgradeParameters.class);
}
