/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SecretType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ValidateSecretInput {
    @JsonProperty(value="secretType", required=true)
    private SecretType secretType;
    @JsonProperty(value="secretSource", required=true)
    private ResourceReference secretSource;
    @JsonProperty(value="secretVersion")
    private String secretVersion;
    private static final ClientLogger LOGGER = new ClientLogger(ValidateSecretInput.class);

    public SecretType secretType() {
        return this.secretType;
    }

    public ValidateSecretInput withSecretType(SecretType secretType) {
        this.secretType = secretType;
        return this;
    }

    public ResourceReference secretSource() {
        return this.secretSource;
    }

    public ValidateSecretInput withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public ValidateSecretInput withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    public void validate() {
        if (this.secretType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property secretType in model ValidateSecretInput"));
        }
        if (this.secretSource() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property secretSource in model ValidateSecretInput"));
        }
        this.secretSource().validate();
    }
}

