// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.models.CanMigrateDefaultSku;
import com.azure.resourcemanager.cdn.models.MigrationErrorType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Result for canMigrate operation.
 */
@Fluent
public final class CanMigrateResultInner {
    /*
     * Resource ID.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * Resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The properties property.
     */
    @JsonProperty(value = "properties")
    private CanMigrateProperties innerProperties;

    /**
     * Creates an instance of CanMigrateResultInner class.
     */
    public CanMigrateResultInner() {
    }

    /**
     * Get the id property: Resource ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: The properties property.
     * 
     * @return the innerProperties value.
     */
    private CanMigrateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the canMigrate property: Flag that says if the profile can be migrated.
     * 
     * @return the canMigrate value.
     */
    public Boolean canMigrate() {
        return this.innerProperties() == null ? null : this.innerProperties().canMigrate();
    }

    /**
     * Get the defaultSku property: Recommended sku for the migration.
     * 
     * @return the defaultSku value.
     */
    public CanMigrateDefaultSku defaultSku() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultSku();
    }

    /**
     * Get the errors property: The errors property.
     * 
     * @return the errors value.
     */
    public List<MigrationErrorType> errors() {
        return this.innerProperties() == null ? null : this.innerProperties().errors();
    }

    /**
     * Set the errors property: The errors property.
     * 
     * @param errors the errors value to set.
     * @return the CanMigrateResultInner object itself.
     */
    public CanMigrateResultInner withErrors(List<MigrationErrorType> errors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CanMigrateProperties();
        }
        this.innerProperties().withErrors(errors);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
