// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cdn.models.ProfileLogScrubbing;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The JSON object containing profile update parameters.
 */
@Fluent
public final class ProfilePropertiesUpdateParameters {
    /*
     * Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and
     * returns.
     */
    @JsonProperty(value = "originResponseTimeoutSeconds")
    private Integer originResponseTimeoutSeconds;

    /*
     * Defines rules to scrub sensitive fields in logs
     */
    @JsonProperty(value = "logScrubbing")
    private ProfileLogScrubbing logScrubbing;

    /**
     * Creates an instance of ProfilePropertiesUpdateParameters class.
     */
    public ProfilePropertiesUpdateParameters() {
    }

    /**
     * Get the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin.
     * When timeout is reached, the request fails and returns.
     * 
     * @return the originResponseTimeoutSeconds value.
     */
    public Integer originResponseTimeoutSeconds() {
        return this.originResponseTimeoutSeconds;
    }

    /**
     * Set the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin.
     * When timeout is reached, the request fails and returns.
     * 
     * @param originResponseTimeoutSeconds the originResponseTimeoutSeconds value to set.
     * @return the ProfilePropertiesUpdateParameters object itself.
     */
    public ProfilePropertiesUpdateParameters withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        this.originResponseTimeoutSeconds = originResponseTimeoutSeconds;
        return this;
    }

    /**
     * Get the logScrubbing property: Defines rules to scrub sensitive fields in logs.
     * 
     * @return the logScrubbing value.
     */
    public ProfileLogScrubbing logScrubbing() {
        return this.logScrubbing;
    }

    /**
     * Set the logScrubbing property: Defines rules to scrub sensitive fields in logs.
     * 
     * @param logScrubbing the logScrubbing value to set.
     * @return the ProfilePropertiesUpdateParameters object itself.
     */
    public ProfilePropertiesUpdateParameters withLogScrubbing(ProfileLogScrubbing logScrubbing) {
        this.logScrubbing = logScrubbing;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (logScrubbing() != null) {
            logScrubbing().validate();
        }
    }
}
