// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.AfdCustomDomainsClient;
import com.azure.resourcemanager.cdn.fluent.models.AfdDomainInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidationTokenInner;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.AfdDomainListResult;
import com.azure.resourcemanager.cdn.models.AfdDomainUpdateParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in AfdCustomDomainsClient. */
public final class AfdCustomDomainsClientImpl implements AfdCustomDomainsClient {
    private final ClientLogger logger = new ClientLogger(AfdCustomDomainsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final AfdCustomDomainsService service;

    /** The service client containing this operation class. */
    private final CdnManagementClientImpl client;

    /**
     * Initializes an instance of AfdCustomDomainsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    AfdCustomDomainsClientImpl(CdnManagementClientImpl client) {
        this.service =
            RestProxy.create(AfdCustomDomainsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CdnManagementClientAfdCustomDomains to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CdnManagementClientA")
    private interface AfdCustomDomainsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/customDomains")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AfdDomainListResult>> listByProfile(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/customDomains/{customDomainName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AfdDomainInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("customDomainName") String customDomainName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/customDomains/{customDomainName}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("customDomainName") String customDomainName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AfdDomainInner customDomain,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/customDomains/{customDomainName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("customDomainName") String customDomainName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") AfdDomainUpdateParameters customDomainUpdateProperties,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/customDomains/{customDomainName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("customDomainName") String customDomainName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/customDomains/{customDomainName}/refreshValidationToken")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> refreshValidationToken(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("customDomainName") String customDomainName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<AfdDomainListResult>> listByProfileNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdDomainInner>> listByProfileSinglePageAsync(
        String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByProfile(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<AfdDomainInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdDomainInner>> listByProfileSinglePageAsync(
        String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByProfile(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AfdDomainInner> listByProfileAsync(String resourceGroupName, String profileName) {
        return new PagedFlux<>(
            () -> listByProfileSinglePageAsync(resourceGroupName, profileName),
            nextLink -> listByProfileNextSinglePageAsync(nextLink));
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<AfdDomainInner> listByProfileAsync(
        String resourceGroupName, String profileName, Context context) {
        return new PagedFlux<>(
            () -> listByProfileSinglePageAsync(resourceGroupName, profileName, context),
            nextLink -> listByProfileNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AfdDomainInner> listByProfile(String resourceGroupName, String profileName) {
        return new PagedIterable<>(listByProfileAsync(resourceGroupName, profileName));
    }

    /**
     * Lists existing AzureFrontDoor domains.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AfdDomainInner> listByProfile(String resourceGroupName, String profileName, Context context) {
        return new PagedIterable<>(listByProfileAsync(resourceGroupName, profileName, context));
    }

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     *     resource group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AfdDomainInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            customDomainName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     *     resource group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<AfdDomainInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                customDomainName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     *     resource group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdDomainInner> getAsync(String resourceGroupName, String profileName, String customDomainName) {
        return getWithResponseAsync(resourceGroupName, profileName, customDomainName)
            .flatMap(
                (Response<AfdDomainInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     *     resource group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdDomainInner get(String resourceGroupName, String profileName, String customDomainName) {
        return getAsync(resourceGroupName, profileName, customDomainName).block();
    }

    /**
     * Gets an existing AzureFrontDoor domain with the specified domain name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     *     resource group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AfdDomainInner> getWithResponse(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        return getWithResponseAsync(resourceGroupName, profileName, customDomainName, context).block();
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomain == null) {
            return Mono.error(new IllegalArgumentException("Parameter customDomain is required and cannot be null."));
        } else {
            customDomain.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            customDomainName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            customDomain,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainInner customDomain,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomain == null) {
            return Mono.error(new IllegalArgumentException("Parameter customDomain is required and cannot be null."));
        } else {
            customDomain.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                customDomainName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                customDomain,
                accept,
                context);
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginCreateAsync(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(resourceGroupName, profileName, customDomainName, customDomain);
        return this
            .client
            .<AfdDomainInner, AfdDomainInner>getLroResult(
                mono, this.client.getHttpPipeline(), AfdDomainInner.class, AfdDomainInner.class, Context.NONE);
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginCreateAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainInner customDomain,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(resourceGroupName, profileName, customDomainName, customDomain, context);
        return this
            .client
            .<AfdDomainInner, AfdDomainInner>getLroResult(
                mono, this.client.getHttpPipeline(), AfdDomainInner.class, AfdDomainInner.class, context);
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginCreate(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        return beginCreateAsync(resourceGroupName, profileName, customDomainName, customDomain).getSyncPoller();
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginCreate(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainInner customDomain,
        Context context) {
        return beginCreateAsync(resourceGroupName, profileName, customDomainName, customDomain, context)
            .getSyncPoller();
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdDomainInner> createAsync(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        return beginCreateAsync(resourceGroupName, profileName, customDomainName, customDomain)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AfdDomainInner> createAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainInner customDomain,
        Context context) {
        return beginCreateAsync(resourceGroupName, profileName, customDomainName, customDomain, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdDomainInner create(
        String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        return createAsync(resourceGroupName, profileName, customDomainName, customDomain).block();
    }

    /**
     * Creates a new domain within the specified profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param customDomain Domain properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdDomainInner create(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainInner customDomain,
        Context context) {
        return createAsync(resourceGroupName, profileName, customDomainName, customDomain, context).block();
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tlsSettings != null) {
            tlsSettings.validate();
        }
        if (azureDnsZone != null) {
            azureDnsZone.validate();
        }
        final String accept = "application/json";
        AfdDomainUpdateParameters customDomainUpdateProperties = new AfdDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(tlsSettings);
        customDomainUpdateProperties.withAzureDnsZone(azureDnsZone);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            customDomainName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            customDomainUpdateProperties,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tlsSettings != null) {
            tlsSettings.validate();
        }
        if (azureDnsZone != null) {
            azureDnsZone.validate();
        }
        final String accept = "application/json";
        AfdDomainUpdateParameters customDomainUpdateProperties = new AfdDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(tlsSettings);
        customDomainUpdateProperties.withAzureDnsZone(azureDnsZone);
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                customDomainName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                customDomainUpdateProperties,
                accept,
                context);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdateAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone);
        return this
            .client
            .<AfdDomainInner, AfdDomainInner>getLroResult(
                mono, this.client.getHttpPipeline(), AfdDomainInner.class, AfdDomainInner.class, Context.NONE);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdateAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(
                resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone, context);
        return this
            .client
            .<AfdDomainInner, AfdDomainInner>getLroResult(
                mono, this.client.getHttpPipeline(), AfdDomainInner.class, AfdDomainInner.class, context);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone) {
        return beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone)
            .getSyncPoller();
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone,
        Context context) {
        return beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone, context)
            .getSyncPoller();
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdDomainInner> updateAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone) {
        return beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AfdDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName) {
        final AfdDomainHttpsParameters tlsSettings = null;
        final ResourceReference azureDnsZone = null;
        return beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<AfdDomainInner> updateAsync(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone,
        Context context) {
        return beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdDomainInner update(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone) {
        return updateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).block();
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdDomainInner update(String resourceGroupName, String profileName, String customDomainName) {
        final AfdDomainHttpsParameters tlsSettings = null;
        final ResourceReference azureDnsZone = null;
        return updateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).block();
    }

    /**
     * Updates an existing domain within a profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param tlsSettings The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed
     *     certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor managed certificate
     *     by default.
     * @param azureDnsZone Resource reference to the Azure DNS zone.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
     *     e.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AfdDomainInner update(
        String resourceGroupName,
        String profileName,
        String customDomainName,
        AfdDomainHttpsParameters tlsSettings,
        ResourceReference azureDnsZone,
        Context context) {
        return updateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone, context)
            .block();
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            customDomainName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                customDomainName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String profileName, String customDomainName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, profileName, customDomainName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, profileName, customDomainName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String customDomainName) {
        return beginDeleteAsync(resourceGroupName, profileName, customDomainName).getSyncPoller();
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        return beginDeleteAsync(resourceGroupName, profileName, customDomainName, context).getSyncPoller();
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String customDomainName) {
        return beginDeleteAsync(resourceGroupName, profileName, customDomainName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        return beginDeleteAsync(resourceGroupName, profileName, customDomainName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String customDomainName) {
        deleteAsync(resourceGroupName, profileName, customDomainName).block();
    }

    /**
     * Deletes an existing AzureFrontDoor domain with the specified domain name under the specified subscription,
     * resource group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String customDomainName, Context context) {
        deleteAsync(resourceGroupName, profileName, customDomainName, context).block();
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> refreshValidationTokenWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .refreshValidationToken(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            customDomainName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> refreshValidationTokenWithResponseAsync(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .refreshValidationToken(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                customDomainName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationTokenAsync(
        String resourceGroupName, String profileName, String customDomainName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            refreshValidationTokenWithResponseAsync(resourceGroupName, profileName, customDomainName);
        return this
            .client
            .<ValidationTokenInner, ValidationTokenInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ValidationTokenInner.class,
                ValidationTokenInner.class,
                Context.NONE);
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationTokenAsync(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            refreshValidationTokenWithResponseAsync(resourceGroupName, profileName, customDomainName, context);
        return this
            .client
            .<ValidationTokenInner, ValidationTokenInner>getLroResult(
                mono, this.client.getHttpPipeline(), ValidationTokenInner.class, ValidationTokenInner.class, context);
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationToken(
        String resourceGroupName, String profileName, String customDomainName) {
        return beginRefreshValidationTokenAsync(resourceGroupName, profileName, customDomainName).getSyncPoller();
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationToken(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        return beginRefreshValidationTokenAsync(resourceGroupName, profileName, customDomainName, context)
            .getSyncPoller();
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ValidationTokenInner> refreshValidationTokenAsync(
        String resourceGroupName, String profileName, String customDomainName) {
        return beginRefreshValidationTokenAsync(resourceGroupName, profileName, customDomainName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ValidationTokenInner> refreshValidationTokenAsync(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        return beginRefreshValidationTokenAsync(resourceGroupName, profileName, customDomainName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ValidationTokenInner refreshValidationToken(
        String resourceGroupName, String profileName, String customDomainName) {
        return refreshValidationTokenAsync(resourceGroupName, profileName, customDomainName).block();
    }

    /**
     * Updates the domain validation token.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param customDomainName Name of the domain under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the validation token.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ValidationTokenInner refreshValidationToken(
        String resourceGroupName, String profileName, String customDomainName, Context context) {
        return refreshValidationTokenAsync(resourceGroupName, profileName, customDomainName, context).block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdDomainInner>> listByProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByProfileNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<AfdDomainInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list domains.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<AfdDomainInner>> listByProfileNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByProfileNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
