// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Defines the parameters for the request header action. */
@Fluent
public final class HeaderActionParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(HeaderActionParameters.class);

    /*
     * The @odata.type property.
     */
    @JsonProperty(value = "@odata.type", required = true)
    private String odataType;

    /*
     * Action to perform
     */
    @JsonProperty(value = "headerAction", required = true)
    private HeaderAction headerAction;

    /*
     * Name of the header to modify
     */
    @JsonProperty(value = "headerName", required = true)
    private String headerName;

    /*
     * Value for the specified action
     */
    @JsonProperty(value = "value")
    private String value;

    /** Creates an instance of HeaderActionParameters class. */
    public HeaderActionParameters() {
        odataType = "#Microsoft.Azure.Cdn.Models.DeliveryRuleHeaderActionParameters";
    }

    /**
     * Get the odataType property: The @odata.type property.
     *
     * @return the odataType value.
     */
    public String odataType() {
        return this.odataType;
    }

    /**
     * Set the odataType property: The @odata.type property.
     *
     * @param odataType the odataType value to set.
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withOdataType(String odataType) {
        this.odataType = odataType;
        return this;
    }

    /**
     * Get the headerAction property: Action to perform.
     *
     * @return the headerAction value.
     */
    public HeaderAction headerAction() {
        return this.headerAction;
    }

    /**
     * Set the headerAction property: Action to perform.
     *
     * @param headerAction the headerAction value to set.
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withHeaderAction(HeaderAction headerAction) {
        this.headerAction = headerAction;
        return this;
    }

    /**
     * Get the headerName property: Name of the header to modify.
     *
     * @return the headerName value.
     */
    public String headerName() {
        return this.headerName;
    }

    /**
     * Set the headerName property: Name of the header to modify.
     *
     * @param headerName the headerName value to set.
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    /**
     * Get the value property: Value for the specified action.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Value for the specified action.
     *
     * @param value the value value to set.
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (headerAction() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property headerAction in model HeaderActionParameters"));
        }
        if (headerName() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property headerName in model HeaderActionParameters"));
        }
    }
}
