// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for Transform. */
public final class Transform extends ExpandableStringEnum<Transform> {
    /** Static value Lowercase for Transform. */
    public static final Transform LOWERCASE = fromString("Lowercase");

    /** Static value Uppercase for Transform. */
    public static final Transform UPPERCASE = fromString("Uppercase");

    /**
     * Creates or finds a Transform from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding Transform.
     */
    @JsonCreator
    public static Transform fromString(String name) {
        return fromString(name, Transform.class);
    }

    /** @return known Transform values. */
    public static Collection<Transform> values() {
        return values(Transform.class);
    }
}
