/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.AfdCustomDomainsClient;
import com.azure.resourcemanager.cdn.fluent.models.AfdDomainInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidationTokenInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.AfdDomainListResult;
import com.azure.resourcemanager.cdn.models.AfdDomainUpdateParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AfdCustomDomainsClientImpl
implements AfdCustomDomainsClient {
    private final ClientLogger logger = new ClientLogger(AfdCustomDomainsClientImpl.class);
    private final AfdCustomDomainsService service;
    private final CdnManagementClientImpl client;

    AfdCustomDomainsClientImpl(CdnManagementClientImpl client) {
        this.service = (AfdCustomDomainsService)RestProxy.create(AfdCustomDomainsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<AfdDomainInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfile(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdDomainListResult)res.getValue()).value(), ((AfdDomainListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<AfdDomainInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfile(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdDomainListResult)res.getValue()).value(), ((AfdDomainListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<AfdDomainInner> listByProfileAsync(String resourceGroupName, String profileName) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<AfdDomainInner> listByProfileAsync(String resourceGroupName, String profileName, Context context) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName, context), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<AfdDomainInner> listByProfile(String resourceGroupName, String profileName) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName));
    }

    @Override
    public PagedIterable<AfdDomainInner> listByProfile(String resourceGroupName, String profileName, Context context) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName, context));
    }

    @Override
    public Mono<Response<AfdDomainInner>> getWithResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<AfdDomainInner>> getWithResponseAsync(String resourceGroupName, String profileName, String customDomainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<AfdDomainInner> getAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.getWithResponseAsync(resourceGroupName, profileName, customDomainName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AfdDomainInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public AfdDomainInner get(String resourceGroupName, String profileName, String customDomainName) {
        return (AfdDomainInner)((Object)this.getAsync(resourceGroupName, profileName, customDomainName).block());
    }

    @Override
    public Response<AfdDomainInner> getWithResponse(String resourceGroupName, String profileName, String customDomainName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, customDomainName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomain == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomain is required and cannot be null."));
        }
        customDomain.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomain, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (customDomain == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomain is required and cannot be null."));
        }
        customDomain.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomain, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, customDomainName, customDomain);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdDomainInner.class), (Type)((Object)AfdDomainInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginCreateAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, customDomainName, customDomain, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdDomainInner.class), (Type)((Object)AfdDomainInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginCreate(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        return this.beginCreateAsync(resourceGroupName, profileName, customDomainName, customDomain).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginCreate(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, customDomainName, customDomain, context).getSyncPoller();
    }

    @Override
    public Mono<AfdDomainInner> createAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        return this.beginCreateAsync(resourceGroupName, profileName, customDomainName, customDomain).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<AfdDomainInner> createAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, customDomainName, customDomain, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public AfdDomainInner create(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain) {
        return (AfdDomainInner)((Object)this.createAsync(resourceGroupName, profileName, customDomainName, customDomain).block());
    }

    @Override
    public AfdDomainInner create(String resourceGroupName, String profileName, String customDomainName, AfdDomainInner customDomain, Context context) {
        return (AfdDomainInner)((Object)this.createAsync(resourceGroupName, profileName, customDomainName, customDomain, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tlsSettings != null) {
            tlsSettings.validate();
        }
        if (azureDnsZone != null) {
            azureDnsZone.validate();
        }
        String accept = "application/json";
        AfdDomainUpdateParameters customDomainUpdateProperties = new AfdDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(tlsSettings);
        customDomainUpdateProperties.withAzureDnsZone(azureDnsZone);
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainUpdateProperties, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (tlsSettings != null) {
            tlsSettings.validate();
        }
        if (azureDnsZone != null) {
            azureDnsZone.validate();
        }
        String accept = "application/json";
        AfdDomainUpdateParameters customDomainUpdateProperties = new AfdDomainUpdateParameters();
        customDomainUpdateProperties.withTlsSettings(tlsSettings);
        customDomainUpdateProperties.withAzureDnsZone(azureDnsZone);
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), customDomainUpdateProperties, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdDomainInner.class), (Type)((Object)AfdDomainInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdateAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdDomainInner.class), (Type)((Object)AfdDomainInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdate(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return this.beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<AfdDomainInner>, AfdDomainInner> beginUpdate(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone, context).getSyncPoller();
    }

    @Override
    public Mono<AfdDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return this.beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<AfdDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName) {
        AfdDomainHttpsParameters tlsSettings = null;
        ResourceReference azureDnsZone = null;
        return this.beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<AfdDomainInner> updateAsync(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public AfdDomainInner update(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone) {
        return (AfdDomainInner)((Object)this.updateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).block());
    }

    @Override
    public AfdDomainInner update(String resourceGroupName, String profileName, String customDomainName) {
        AfdDomainHttpsParameters tlsSettings = null;
        ResourceReference azureDnsZone = null;
        return (AfdDomainInner)((Object)this.updateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone).block());
    }

    @Override
    public AfdDomainInner update(String resourceGroupName, String profileName, String customDomainName, AfdDomainHttpsParameters tlsSettings, ResourceReference azureDnsZone, Context context) {
        return (AfdDomainInner)((Object)this.updateAsync(resourceGroupName, profileName, customDomainName, tlsSettings, azureDnsZone, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String customDomainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String customDomainName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, customDomainName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String customDomainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, customDomainName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String customDomainName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, customDomainName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String customDomainName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, customDomainName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, customDomainName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String customDomainName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, customDomainName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String profileName, String customDomainName) {
        this.deleteAsync(resourceGroupName, profileName, customDomainName).block();
    }

    @Override
    public void delete(String resourceGroupName, String profileName, String customDomainName, Context context) {
        this.deleteAsync(resourceGroupName, profileName, customDomainName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> refreshValidationTokenWithResponseAsync(String resourceGroupName, String profileName, String customDomainName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.refreshValidationToken(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> refreshValidationTokenWithResponseAsync(String resourceGroupName, String profileName, String customDomainName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (customDomainName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter customDomainName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.refreshValidationToken(this.client.getEndpoint(), resourceGroupName, profileName, customDomainName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.refreshValidationTokenWithResponseAsync(resourceGroupName, profileName, customDomainName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ValidationTokenInner.class), (Type)((Object)ValidationTokenInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.refreshValidationTokenWithResponseAsync(resourceGroupName, profileName, customDomainName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ValidationTokenInner.class), (Type)((Object)ValidationTokenInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationToken(String resourceGroupName, String profileName, String customDomainName) {
        return this.beginRefreshValidationTokenAsync(resourceGroupName, profileName, customDomainName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ValidationTokenInner>, ValidationTokenInner> beginRefreshValidationToken(String resourceGroupName, String profileName, String customDomainName, Context context) {
        return this.beginRefreshValidationTokenAsync(resourceGroupName, profileName, customDomainName, context).getSyncPoller();
    }

    @Override
    public Mono<ValidationTokenInner> refreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName) {
        return this.beginRefreshValidationTokenAsync(resourceGroupName, profileName, customDomainName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ValidationTokenInner> refreshValidationTokenAsync(String resourceGroupName, String profileName, String customDomainName, Context context) {
        return this.beginRefreshValidationTokenAsync(resourceGroupName, profileName, customDomainName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ValidationTokenInner refreshValidationToken(String resourceGroupName, String profileName, String customDomainName) {
        return (ValidationTokenInner)this.refreshValidationTokenAsync(resourceGroupName, profileName, customDomainName).block();
    }

    @Override
    public ValidationTokenInner refreshValidationToken(String resourceGroupName, String profileName, String customDomainName, Context context) {
        return (ValidationTokenInner)this.refreshValidationTokenAsync(resourceGroupName, profileName, customDomainName, context).block();
    }

    private Mono<PagedResponse<AfdDomainInner>> listByProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdDomainListResult)res.getValue()).value(), ((AfdDomainListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<AfdDomainInner>> listByProfileNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdDomainListResult)res.getValue()).value(), ((AfdDomainListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientA")
    private static interface AfdCustomDomainsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AfdDomainListResult>> listByProfile(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AfdDomainInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="customDomainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="customDomainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AfdDomainInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="customDomainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") AfdDomainUpdateParameters var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="customDomainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/customDomains/{customDomainName}/refreshValidationToken")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> refreshValidationToken(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="customDomainName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AfdDomainListResult>> listByProfileNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

