/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.AfdProfilesClient;
import com.azure.resourcemanager.cdn.fluent.models.UsageInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidateCustomDomainOutputInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.UsagesListResult;
import com.azure.resourcemanager.cdn.models.ValidateCustomDomainInput;
import reactor.core.publisher.Mono;

public final class AfdProfilesClientImpl
implements AfdProfilesClient {
    private final ClientLogger logger = new ClientLogger(AfdProfilesClientImpl.class);
    private final AfdProfilesService service;
    private final CdnManagementClientImpl client;

    AfdProfilesClientImpl(CdnManagementClientImpl client) {
        this.service = (AfdProfilesService)RestProxy.create(AfdProfilesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<UsageInner>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listResourceUsage(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesListResult)res.getValue()).value(), ((UsagesListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<UsageInner>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listResourceUsage(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesListResult)res.getValue()).value(), ((UsagesListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<UsageInner> listResourceUsageAsync(String resourceGroupName, String profileName) {
        return new PagedFlux(() -> this.listResourceUsageSinglePageAsync(resourceGroupName, profileName), nextLink -> this.listResourceUsageNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<UsageInner> listResourceUsageAsync(String resourceGroupName, String profileName, Context context) {
        return new PagedFlux(() -> this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, context), nextLink -> this.listResourceUsageNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<UsageInner> listResourceUsage(String resourceGroupName, String profileName) {
        return new PagedIterable(this.listResourceUsageAsync(resourceGroupName, profileName));
    }

    @Override
    public PagedIterable<UsageInner> listResourceUsage(String resourceGroupName, String profileName, Context context) {
        return new PagedIterable(this.listResourceUsageAsync(resourceGroupName, profileName, context));
    }

    @Override
    public Mono<Response<ValidateCustomDomainOutputInner>> checkHostnameAvailabilityWithResponseAsync(String resourceGroupName, String profileName, String hostname) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        String accept = "application/json";
        ValidateCustomDomainInput checkHostnameAvailabilityInput = new ValidateCustomDomainInput();
        checkHostnameAvailabilityInput.withHostname(hostname);
        return FluxUtil.withContext(context -> this.service.checkHostnameAvailability(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), checkHostnameAvailabilityInput, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ValidateCustomDomainOutputInner>> checkHostnameAvailabilityWithResponseAsync(String resourceGroupName, String profileName, String hostname, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        String accept = "application/json";
        ValidateCustomDomainInput checkHostnameAvailabilityInput = new ValidateCustomDomainInput();
        checkHostnameAvailabilityInput.withHostname(hostname);
        context = this.client.mergeContext(context);
        return this.service.checkHostnameAvailability(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), checkHostnameAvailabilityInput, "application/json", context);
    }

    @Override
    public Mono<ValidateCustomDomainOutputInner> checkHostnameAvailabilityAsync(String resourceGroupName, String profileName, String hostname) {
        return this.checkHostnameAvailabilityWithResponseAsync(resourceGroupName, profileName, hostname).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ValidateCustomDomainOutputInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ValidateCustomDomainOutputInner checkHostnameAvailability(String resourceGroupName, String profileName, String hostname) {
        return (ValidateCustomDomainOutputInner)this.checkHostnameAvailabilityAsync(resourceGroupName, profileName, hostname).block();
    }

    @Override
    public Response<ValidateCustomDomainOutputInner> checkHostnameAvailabilityWithResponse(String resourceGroupName, String profileName, String hostname, Context context) {
        return (Response)this.checkHostnameAvailabilityWithResponseAsync(resourceGroupName, profileName, hostname, context).block();
    }

    private Mono<PagedResponse<UsageInner>> listResourceUsageNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listResourceUsageNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesListResult)res.getValue()).value(), ((UsagesListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<UsageInner>> listResourceUsageNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listResourceUsageNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UsagesListResult)res.getValue()).value(), ((UsagesListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientA")
    private static interface AfdProfilesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/usages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UsagesListResult>> listResourceUsage(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/checkHostNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidateCustomDomainOutputInner>> checkHostnameAvailability(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") ValidateCustomDomainInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<UsagesListResult>> listResourceUsageNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

