/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.OriginGroupsClient;
import com.azure.resourcemanager.cdn.fluent.models.OriginGroupInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.OriginGroupListResult;
import com.azure.resourcemanager.cdn.models.OriginGroupUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class OriginGroupsClientImpl
implements OriginGroupsClient {
    private final ClientLogger logger = new ClientLogger(OriginGroupsClientImpl.class);
    private final OriginGroupsService service;
    private final CdnManagementClientImpl client;

    OriginGroupsClientImpl(CdnManagementClientImpl client) {
        this.service = (OriginGroupsService)RestProxy.create(OriginGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<OriginGroupInner>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByEndpoint(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OriginGroupListResult)res.getValue()).value(), ((OriginGroupListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<OriginGroupInner>> listByEndpointSinglePageAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByEndpoint(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OriginGroupListResult)res.getValue()).value(), ((OriginGroupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<OriginGroupInner> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName) {
        return new PagedFlux(() -> this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName), nextLink -> this.listByEndpointNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<OriginGroupInner> listByEndpointAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedFlux(() -> this.listByEndpointSinglePageAsync(resourceGroupName, profileName, endpointName, context), nextLink -> this.listByEndpointNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<OriginGroupInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName) {
        return new PagedIterable(this.listByEndpointAsync(resourceGroupName, profileName, endpointName));
    }

    @Override
    public PagedIterable<OriginGroupInner> listByEndpoint(String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedIterable(this.listByEndpointAsync(resourceGroupName, profileName, endpointName, context));
    }

    @Override
    public Mono<Response<OriginGroupInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<OriginGroupInner>> getWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<OriginGroupInner> getAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return this.getWithResponseAsync(resourceGroupName, profileName, endpointName, originGroupName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((OriginGroupInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public OriginGroupInner get(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return (OriginGroupInner)((Object)this.getAsync(resourceGroupName, profileName, endpointName, originGroupName).block());
    }

    @Override
    public Response<OriginGroupInner> getWithResponse(String resourceGroupName, String profileName, String endpointName, String originGroupName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originGroup == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroup is required and cannot be null."));
        }
        originGroup.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), originGroup, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originGroup == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroup is required and cannot be null."));
        }
        originGroup.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), originGroup, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<OriginGroupInner>, OriginGroupInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OriginGroupInner.class), (Type)((Object)OriginGroupInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<OriginGroupInner>, OriginGroupInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OriginGroupInner.class), (Type)((Object)OriginGroupInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<OriginGroupInner>, OriginGroupInner> beginCreate(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<OriginGroupInner>, OriginGroupInner> beginCreate(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup, context).getSyncPoller();
    }

    @Override
    public Mono<OriginGroupInner> createAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<OriginGroupInner> createAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public OriginGroupInner create(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup) {
        return (OriginGroupInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup).block());
    }

    @Override
    public OriginGroupInner create(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupInner originGroup, Context context) {
        return (OriginGroupInner)((Object)this.createAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroup, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originGroupUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null."));
        }
        originGroupUpdateProperties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), originGroupUpdateProperties, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originGroupUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupUpdateProperties is required and cannot be null."));
        }
        originGroupUpdateProperties.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), originGroupUpdateProperties, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<OriginGroupInner>, OriginGroupInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OriginGroupInner.class), (Type)((Object)OriginGroupInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<OriginGroupInner>, OriginGroupInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OriginGroupInner.class), (Type)((Object)OriginGroupInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<OriginGroupInner>, OriginGroupInner> beginUpdate(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<OriginGroupInner>, OriginGroupInner> beginUpdate(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties, context).getSyncPoller();
    }

    @Override
    public Mono<OriginGroupInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<OriginGroupInner> updateAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public OriginGroupInner update(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties) {
        return (OriginGroupInner)((Object)this.updateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties).block());
    }

    @Override
    public OriginGroupInner update(String resourceGroupName, String profileName, String endpointName, String originGroupName, OriginGroupUpdateParameters originGroupUpdateProperties, Context context) {
        return (OriginGroupInner)((Object)this.updateAsync(resourceGroupName, profileName, endpointName, originGroupName, originGroupUpdateProperties, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, endpointName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName, originGroupName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, endpointName, originGroupName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, originGroupName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String endpointName, String originGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, originGroupName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, originGroupName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, String originGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, endpointName, originGroupName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String profileName, String endpointName, String originGroupName) {
        this.deleteAsync(resourceGroupName, profileName, endpointName, originGroupName).block();
    }

    @Override
    public void delete(String resourceGroupName, String profileName, String endpointName, String originGroupName, Context context) {
        this.deleteAsync(resourceGroupName, profileName, endpointName, originGroupName, context).block();
    }

    private Mono<PagedResponse<OriginGroupInner>> listByEndpointNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByEndpointNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OriginGroupListResult)res.getValue()).value(), ((OriginGroupListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<OriginGroupInner>> listByEndpointNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByEndpointNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OriginGroupListResult)res.getValue()).value(), ((OriginGroupListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientO")
    private static interface OriginGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OriginGroupListResult>> listByEndpoint(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OriginGroupInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="originGroupName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="originGroupName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") OriginGroupInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="originGroupName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") OriginGroupUpdateParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/originGroups/{originGroupName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="endpointName") String var4, @PathParam(value="originGroupName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<OriginGroupListResult>> listByEndpointNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

