/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.SecretsClient;
import com.azure.resourcemanager.cdn.fluent.models.SecretInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.SecretListResult;
import com.azure.resourcemanager.cdn.models.SecretParameters;
import com.azure.resourcemanager.cdn.models.SecretProperties;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SecretsClientImpl
implements SecretsClient {
    private final ClientLogger logger = new ClientLogger(SecretsClientImpl.class);
    private final SecretsService service;
    private final CdnManagementClientImpl client;

    SecretsClientImpl(CdnManagementClientImpl client) {
        this.service = (SecretsService)RestProxy.create(SecretsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<SecretInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfile(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).value(), ((SecretListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SecretInner>> listByProfileSinglePageAsync(String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfile(this.client.getEndpoint(), resourceGroupName, profileName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).value(), ((SecretListResult)res.getValue()).nextLink(), null));
    }

    @Override
    public PagedFlux<SecretInner> listByProfileAsync(String resourceGroupName, String profileName) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<SecretInner> listByProfileAsync(String resourceGroupName, String profileName, Context context) {
        return new PagedFlux(() -> this.listByProfileSinglePageAsync(resourceGroupName, profileName, context), nextLink -> this.listByProfileNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<SecretInner> listByProfile(String resourceGroupName, String profileName) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName));
    }

    @Override
    public PagedIterable<SecretInner> listByProfile(String resourceGroupName, String profileName, Context context) {
        return new PagedIterable(this.listByProfileAsync(resourceGroupName, profileName, context));
    }

    @Override
    public Mono<Response<SecretInner>> getWithResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, secretName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<SecretInner>> getWithResponseAsync(String resourceGroupName, String profileName, String secretName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, secretName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public Mono<SecretInner> getAsync(String resourceGroupName, String profileName, String secretName) {
        return this.getWithResponseAsync(resourceGroupName, profileName, secretName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SecretInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public SecretInner get(String resourceGroupName, String profileName, String secretName) {
        return (SecretInner)((Object)this.getAsync(resourceGroupName, profileName, secretName).block());
    }

    @Override
    public Response<SecretInner> getWithResponse(String resourceGroupName, String profileName, String secretName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, secretName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String accept = "application/json";
        SecretInner secret = new SecretInner();
        secret.withParameters(parameters);
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, secretName, this.client.getSubscriptionId(), this.client.getApiVersion(), secret, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String accept = "application/json";
        SecretInner secret = new SecretInner();
        secret.withParameters(parameters);
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, secretName, this.client.getSubscriptionId(), this.client.getApiVersion(), secret, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<SecretInner>, SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, secretName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SecretInner.class), (Type)((Object)SecretInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<SecretInner>, SecretInner> beginCreateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, secretName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SecretInner.class), (Type)((Object)SecretInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<SecretInner>, SecretInner> beginCreate(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return this.beginCreateAsync(resourceGroupName, profileName, secretName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<SecretInner>, SecretInner> beginCreate(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, secretName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return this.beginCreateAsync(resourceGroupName, profileName, secretName, parameters).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName) {
        SecretParameters parameters = null;
        return this.beginCreateAsync(resourceGroupName, profileName, secretName, parameters).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<SecretInner> createAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, secretName, parameters, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public SecretInner create(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return (SecretInner)((Object)this.createAsync(resourceGroupName, profileName, secretName, parameters).block());
    }

    @Override
    public SecretInner create(String resourceGroupName, String profileName, String secretName) {
        SecretParameters parameters = null;
        return (SecretInner)((Object)this.createAsync(resourceGroupName, profileName, secretName, parameters).block());
    }

    @Override
    public SecretInner create(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        return (SecretInner)((Object)this.createAsync(resourceGroupName, profileName, secretName, parameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String accept = "application/json";
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(parameters);
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, secretName, this.client.getSubscriptionId(), this.client.getApiVersion(), secretProperties, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String accept = "application/json";
        SecretProperties secretProperties = new SecretProperties();
        secretProperties.withParameters(parameters);
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, secretName, this.client.getSubscriptionId(), this.client.getApiVersion(), secretProperties, "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<SecretInner>, SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, secretName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SecretInner.class), (Type)((Object)SecretInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<SecretInner>, SecretInner> beginUpdateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, secretName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SecretInner.class), (Type)((Object)SecretInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<SecretInner>, SecretInner> beginUpdate(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return this.beginUpdateAsync(resourceGroupName, profileName, secretName, parameters).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<SecretInner>, SecretInner> beginUpdate(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, secretName, parameters, context).getSyncPoller();
    }

    @Override
    public Mono<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return this.beginUpdateAsync(resourceGroupName, profileName, secretName, parameters).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName) {
        SecretParameters parameters = null;
        return this.beginUpdateAsync(resourceGroupName, profileName, secretName, parameters).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<SecretInner> updateAsync(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, secretName, parameters, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public SecretInner update(String resourceGroupName, String profileName, String secretName, SecretParameters parameters) {
        return (SecretInner)((Object)this.updateAsync(resourceGroupName, profileName, secretName, parameters).block());
    }

    @Override
    public SecretInner update(String resourceGroupName, String profileName, String secretName) {
        SecretParameters parameters = null;
        return (SecretInner)((Object)this.updateAsync(resourceGroupName, profileName, secretName, parameters).block());
    }

    @Override
    public SecretInner update(String resourceGroupName, String profileName, String secretName, SecretParameters parameters, Context context) {
        return (SecretInner)((Object)this.updateAsync(resourceGroupName, profileName, secretName, parameters, context).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String secretName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, secretName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String secretName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (secretName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, secretName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String secretName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, secretName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String secretName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, secretName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String secretName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, secretName).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String secretName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, secretName, context).getSyncPoller();
    }

    @Override
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String secretName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, secretName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String secretName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, secretName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public void delete(String resourceGroupName, String profileName, String secretName) {
        this.deleteAsync(resourceGroupName, profileName, secretName).block();
    }

    @Override
    public void delete(String resourceGroupName, String profileName, String secretName, Context context) {
        this.deleteAsync(resourceGroupName, profileName, secretName, context).block();
    }

    private Mono<PagedResponse<SecretInner>> listByProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).value(), ((SecretListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<SecretInner>> listByProfileNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByProfileNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SecretListResult)res.getValue()).value(), ((SecretListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientS")
    private static interface SecretsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecretListResult>> listByProfile(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecretInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="secretName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="secretName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SecretInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="secretName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") SecretProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/secrets/{secretName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="secretName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<SecretListResult>> listByProfileNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

