/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.ValidatesClient;
import com.azure.resourcemanager.cdn.fluent.models.ValidateSecretOutputInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.ValidateSecretInput;
import com.azure.resourcemanager.cdn.models.ValidateSecretType;
import reactor.core.publisher.Mono;

public final class ValidatesClientImpl
implements ValidatesClient {
    private final ClientLogger logger = new ClientLogger(ValidatesClientImpl.class);
    private final ValidatesService service;
    private final CdnManagementClientImpl client;

    ValidatesClientImpl(CdnManagementClientImpl client) {
        this.service = (ValidatesService)RestProxy.create(ValidatesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ValidateSecretOutputInner>> secretWithResponseAsync(ResourceReference secretSource, ValidateSecretType secretType) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (secretSource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretSource is required and cannot be null."));
        }
        secretSource.validate();
        if (secretType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretType is required and cannot be null."));
        }
        String accept = "application/json";
        ValidateSecretInput validateSecretInput = new ValidateSecretInput();
        validateSecretInput.withSecretSource(secretSource);
        validateSecretInput.withSecretType(secretType);
        return FluxUtil.withContext(context -> this.service.secret(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), validateSecretInput, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ValidateSecretOutputInner>> secretWithResponseAsync(ResourceReference secretSource, ValidateSecretType secretType, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (secretSource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretSource is required and cannot be null."));
        }
        secretSource.validate();
        if (secretType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter secretType is required and cannot be null."));
        }
        String accept = "application/json";
        ValidateSecretInput validateSecretInput = new ValidateSecretInput();
        validateSecretInput.withSecretSource(secretSource);
        validateSecretInput.withSecretType(secretType);
        context = this.client.mergeContext(context);
        return this.service.secret(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), validateSecretInput, "application/json", context);
    }

    @Override
    public Mono<ValidateSecretOutputInner> secretAsync(ResourceReference secretSource, ValidateSecretType secretType) {
        return this.secretWithResponseAsync(secretSource, secretType).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ValidateSecretOutputInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public ValidateSecretOutputInner secret(ResourceReference secretSource, ValidateSecretType secretType) {
        return (ValidateSecretOutputInner)this.secretAsync(secretSource, secretType).block();
    }

    @Override
    public Response<ValidateSecretOutputInner> secretWithResponse(ResourceReference secretSource, ValidateSecretType secretType, Context context) {
        return (Response)this.secretWithResponseAsync(secretSource, secretType, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientV")
    private static interface ValidatesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Cdn/validateSecret")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ValidateSecretOutputInner>> secret(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ValidateSecretInput var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

