/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.CdnManagedHttpsParameters;
import com.azure.resourcemanager.cdn.models.MinimumTlsVersion;
import com.azure.resourcemanager.cdn.models.ProtocolType;
import com.azure.resourcemanager.cdn.models.UserManagedHttpsParameters;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="certificateSource", defaultImpl=CustomDomainHttpsParameters.class)
@JsonTypeName(value="CustomDomainHttpsParameters")
@JsonSubTypes(value={@JsonSubTypes.Type(name="Cdn", value=CdnManagedHttpsParameters.class), @JsonSubTypes.Type(name="AzureKeyVault", value=UserManagedHttpsParameters.class)})
public class CustomDomainHttpsParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CustomDomainHttpsParameters.class);
    @JsonProperty(value="protocolType", required=true)
    private ProtocolType protocolType;
    @JsonProperty(value="minimumTlsVersion")
    private MinimumTlsVersion minimumTlsVersion;

    public ProtocolType protocolType() {
        return this.protocolType;
    }

    public CustomDomainHttpsParameters withProtocolType(ProtocolType protocolType) {
        this.protocolType = protocolType;
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    public CustomDomainHttpsParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    public void validate() {
        if (this.protocolType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property protocolType in model CustomDomainHttpsParameters"));
        }
    }
}

