/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.Algorithm;
import com.azure.resourcemanager.cdn.models.UrlSigningParamIdentifier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class UrlSigningActionParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(UrlSigningActionParameters.class);
    @JsonProperty(value="@odata.type", required=true)
    private String odataType = "#Microsoft.Azure.Cdn.Models.DeliveryRuleUrlSigningActionParameters";
    @JsonProperty(value="algorithm")
    private Algorithm algorithm;
    @JsonProperty(value="parameterNameOverride")
    private List<UrlSigningParamIdentifier> parameterNameOverride;

    public String odataType() {
        return this.odataType;
    }

    public UrlSigningActionParameters withOdataType(String odataType) {
        this.odataType = odataType;
        return this;
    }

    public Algorithm algorithm() {
        return this.algorithm;
    }

    public UrlSigningActionParameters withAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public List<UrlSigningParamIdentifier> parameterNameOverride() {
        return this.parameterNameOverride;
    }

    public UrlSigningActionParameters withParameterNameOverride(List<UrlSigningParamIdentifier> parameterNameOverride) {
        this.parameterNameOverride = parameterNameOverride;
        return this;
    }

    public void validate() {
        if (this.parameterNameOverride() != null) {
            this.parameterNameOverride().forEach(e -> e.validate());
        }
    }
}

