// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the parameters for the request header action.
 */
@Fluent
public final class HeaderActionParameters {
    /*
     * The typeName property.
     */
    @JsonProperty(value = "typeName", required = true)
    private String typeName = "DeliveryRuleHeaderActionParameters";

    /*
     * Action to perform
     */
    @JsonProperty(value = "headerAction", required = true)
    private HeaderAction headerAction;

    /*
     * Name of the header to modify
     */
    @JsonProperty(value = "headerName", required = true)
    private String headerName;

    /*
     * Value for the specified action
     */
    @JsonProperty(value = "value")
    private String value;

    /**
     * Creates an instance of HeaderActionParameters class.
     */
    public HeaderActionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the headerAction property: Action to perform.
     * 
     * @return the headerAction value.
     */
    public HeaderAction headerAction() {
        return this.headerAction;
    }

    /**
     * Set the headerAction property: Action to perform.
     * 
     * @param headerAction the headerAction value to set.
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withHeaderAction(HeaderAction headerAction) {
        this.headerAction = headerAction;
        return this;
    }

    /**
     * Get the headerName property: Name of the header to modify.
     * 
     * @return the headerName value.
     */
    public String headerName() {
        return this.headerName;
    }

    /**
     * Set the headerName property: Name of the header to modify.
     * 
     * @param headerName the headerName value to set.
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withHeaderName(String headerName) {
        this.headerName = headerName;
        return this;
    }

    /**
     * Get the value property: Value for the specified action.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Value for the specified action.
     * 
     * @param value the value value to set.
     * @return the HeaderActionParameters object itself.
     */
    public HeaderActionParameters withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (headerAction() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property headerAction in model HeaderActionParameters"));
        }
        if (headerName() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property headerName in model HeaderActionParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(HeaderActionParameters.class);
}
