// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * State of the log scrubbing config. Default value is Enabled.
 */
public final class ProfileScrubbingState extends ExpandableStringEnum<ProfileScrubbingState> {
    /**
     * Static value Enabled for ProfileScrubbingState.
     */
    public static final ProfileScrubbingState ENABLED = fromString("Enabled");

    /**
     * Static value Disabled for ProfileScrubbingState.
     */
    public static final ProfileScrubbingState DISABLED = fromString("Disabled");

    /**
     * Creates a new instance of ProfileScrubbingState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ProfileScrubbingState() {
    }

    /**
     * Creates or finds a ProfileScrubbingState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ProfileScrubbingState.
     */
    @JsonCreator
    public static ProfileScrubbingState fromString(String name) {
        return fromString(name, ProfileScrubbingState.class);
    }

    /**
     * Gets known ProfileScrubbingState values.
     * 
     * @return known ProfileScrubbingState values.
     */
    public static Collection<ProfileScrubbingState> values() {
        return values(ProfileScrubbingState.class);
    }
}
