/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink;
import com.azure.resourcemanager.cdn.models.GeoFilter;
import com.azure.resourcemanager.cdn.models.OptimizationType;
import com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.UrlSigningKey;
import java.io.IOException;
import java.util.List;

public class EndpointPropertiesUpdateParameters
implements JsonSerializable<EndpointPropertiesUpdateParameters> {
    private String originPath;
    private List<String> contentTypesToCompress;
    private String originHostHeader;
    private Boolean isCompressionEnabled;
    private Boolean isHttpAllowed;
    private Boolean isHttpsAllowed;
    private QueryStringCachingBehavior queryStringCachingBehavior;
    private OptimizationType optimizationType;
    private String probePath;
    private List<GeoFilter> geoFilters;
    private ResourceReference defaultOriginGroup;
    private List<UrlSigningKey> urlSigningKeys;
    private EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy;
    private EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink;

    public String originPath() {
        return this.originPath;
    }

    public EndpointPropertiesUpdateParameters withOriginPath(String originPath) {
        this.originPath = originPath;
        return this;
    }

    public List<String> contentTypesToCompress() {
        return this.contentTypesToCompress;
    }

    public EndpointPropertiesUpdateParameters withContentTypesToCompress(List<String> contentTypesToCompress) {
        this.contentTypesToCompress = contentTypesToCompress;
        return this;
    }

    public String originHostHeader() {
        return this.originHostHeader;
    }

    public EndpointPropertiesUpdateParameters withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    public Boolean isCompressionEnabled() {
        return this.isCompressionEnabled;
    }

    public EndpointPropertiesUpdateParameters withIsCompressionEnabled(Boolean isCompressionEnabled) {
        this.isCompressionEnabled = isCompressionEnabled;
        return this;
    }

    public Boolean isHttpAllowed() {
        return this.isHttpAllowed;
    }

    public EndpointPropertiesUpdateParameters withIsHttpAllowed(Boolean isHttpAllowed) {
        this.isHttpAllowed = isHttpAllowed;
        return this;
    }

    public Boolean isHttpsAllowed() {
        return this.isHttpsAllowed;
    }

    public EndpointPropertiesUpdateParameters withIsHttpsAllowed(Boolean isHttpsAllowed) {
        this.isHttpsAllowed = isHttpsAllowed;
        return this;
    }

    public QueryStringCachingBehavior queryStringCachingBehavior() {
        return this.queryStringCachingBehavior;
    }

    public EndpointPropertiesUpdateParameters withQueryStringCachingBehavior(QueryStringCachingBehavior queryStringCachingBehavior) {
        this.queryStringCachingBehavior = queryStringCachingBehavior;
        return this;
    }

    public OptimizationType optimizationType() {
        return this.optimizationType;
    }

    public EndpointPropertiesUpdateParameters withOptimizationType(OptimizationType optimizationType) {
        this.optimizationType = optimizationType;
        return this;
    }

    public String probePath() {
        return this.probePath;
    }

    public EndpointPropertiesUpdateParameters withProbePath(String probePath) {
        this.probePath = probePath;
        return this;
    }

    public List<GeoFilter> geoFilters() {
        return this.geoFilters;
    }

    public EndpointPropertiesUpdateParameters withGeoFilters(List<GeoFilter> geoFilters) {
        this.geoFilters = geoFilters;
        return this;
    }

    public ResourceReference defaultOriginGroup() {
        return this.defaultOriginGroup;
    }

    public EndpointPropertiesUpdateParameters withDefaultOriginGroup(ResourceReference defaultOriginGroup) {
        this.defaultOriginGroup = defaultOriginGroup;
        return this;
    }

    public List<UrlSigningKey> urlSigningKeys() {
        return this.urlSigningKeys;
    }

    public EndpointPropertiesUpdateParameters withUrlSigningKeys(List<UrlSigningKey> urlSigningKeys) {
        this.urlSigningKeys = urlSigningKeys;
        return this;
    }

    public EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy() {
        return this.deliveryPolicy;
    }

    public EndpointPropertiesUpdateParameters withDeliveryPolicy(EndpointPropertiesUpdateParametersDeliveryPolicy deliveryPolicy) {
        this.deliveryPolicy = deliveryPolicy;
        return this;
    }

    public EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink() {
        return this.webApplicationFirewallPolicyLink;
    }

    public EndpointPropertiesUpdateParameters withWebApplicationFirewallPolicyLink(EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink webApplicationFirewallPolicyLink) {
        this.webApplicationFirewallPolicyLink = webApplicationFirewallPolicyLink;
        return this;
    }

    public void validate() {
        if (this.geoFilters() != null) {
            this.geoFilters().forEach(e -> e.validate());
        }
        if (this.defaultOriginGroup() != null) {
            this.defaultOriginGroup().validate();
        }
        if (this.urlSigningKeys() != null) {
            this.urlSigningKeys().forEach(e -> e.validate());
        }
        if (this.deliveryPolicy() != null) {
            this.deliveryPolicy().validate();
        }
        if (this.webApplicationFirewallPolicyLink() != null) {
            this.webApplicationFirewallPolicyLink().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("originPath", this.originPath);
        jsonWriter.writeArrayField("contentTypesToCompress", this.contentTypesToCompress, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("originHostHeader", this.originHostHeader);
        jsonWriter.writeBooleanField("isCompressionEnabled", this.isCompressionEnabled);
        jsonWriter.writeBooleanField("isHttpAllowed", this.isHttpAllowed);
        jsonWriter.writeBooleanField("isHttpsAllowed", this.isHttpsAllowed);
        jsonWriter.writeStringField("queryStringCachingBehavior", this.queryStringCachingBehavior == null ? null : this.queryStringCachingBehavior.toString());
        jsonWriter.writeStringField("optimizationType", this.optimizationType == null ? null : this.optimizationType.toString());
        jsonWriter.writeStringField("probePath", this.probePath);
        jsonWriter.writeArrayField("geoFilters", this.geoFilters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("defaultOriginGroup", (JsonSerializable)this.defaultOriginGroup);
        jsonWriter.writeArrayField("urlSigningKeys", this.urlSigningKeys, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("deliveryPolicy", (JsonSerializable)this.deliveryPolicy);
        jsonWriter.writeJsonField("webApplicationFirewallPolicyLink", (JsonSerializable)this.webApplicationFirewallPolicyLink);
        return jsonWriter.writeEndObject();
    }

    public static EndpointPropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (EndpointPropertiesUpdateParameters)jsonReader.readObject(reader -> {
            EndpointPropertiesUpdateParameters deserializedEndpointPropertiesUpdateParameters = new EndpointPropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("originPath".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.originPath = reader.getString();
                    continue;
                }
                if ("contentTypesToCompress".equals(fieldName)) {
                    List contentTypesToCompress;
                    deserializedEndpointPropertiesUpdateParameters.contentTypesToCompress = contentTypesToCompress = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("originHostHeader".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.originHostHeader = reader.getString();
                    continue;
                }
                if ("isCompressionEnabled".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.isCompressionEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isHttpAllowed".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.isHttpAllowed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isHttpsAllowed".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.isHttpsAllowed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("queryStringCachingBehavior".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.queryStringCachingBehavior = QueryStringCachingBehavior.fromString(reader.getString());
                    continue;
                }
                if ("optimizationType".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.optimizationType = OptimizationType.fromString(reader.getString());
                    continue;
                }
                if ("probePath".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.probePath = reader.getString();
                    continue;
                }
                if ("geoFilters".equals(fieldName)) {
                    List geoFilters;
                    deserializedEndpointPropertiesUpdateParameters.geoFilters = geoFilters = reader.readArray(reader1 -> GeoFilter.fromJson(reader1));
                    continue;
                }
                if ("defaultOriginGroup".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.defaultOriginGroup = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("urlSigningKeys".equals(fieldName)) {
                    List urlSigningKeys;
                    deserializedEndpointPropertiesUpdateParameters.urlSigningKeys = urlSigningKeys = reader.readArray(reader1 -> UrlSigningKey.fromJson(reader1));
                    continue;
                }
                if ("deliveryPolicy".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.deliveryPolicy = EndpointPropertiesUpdateParametersDeliveryPolicy.fromJson(reader);
                    continue;
                }
                if ("webApplicationFirewallPolicyLink".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParameters.webApplicationFirewallPolicyLink = EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointPropertiesUpdateParameters;
        });
    }
}

