/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import java.io.IOException;

public final class CanMigrateParameters
implements JsonSerializable<CanMigrateParameters> {
    private ResourceReference classicResourceReference;
    private static final ClientLogger LOGGER = new ClientLogger(CanMigrateParameters.class);

    public ResourceReference classicResourceReference() {
        return this.classicResourceReference;
    }

    public CanMigrateParameters withClassicResourceReference(ResourceReference classicResourceReference) {
        this.classicResourceReference = classicResourceReference;
        return this;
    }

    public void validate() {
        if (this.classicResourceReference() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property classicResourceReference in model CanMigrateParameters"));
        }
        this.classicResourceReference().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("classicResourceReference", (JsonSerializable)this.classicResourceReference);
        return jsonWriter.writeEndObject();
    }

    public static CanMigrateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CanMigrateParameters)jsonReader.readObject(reader -> {
            CanMigrateParameters deserializedCanMigrateParameters = new CanMigrateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classicResourceReference".equals(fieldName)) {
                    deserializedCanMigrateParameters.classicResourceReference = ResourceReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCanMigrateParameters;
        });
    }
}

