/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeliveryRuleActionValue;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCacheExpirationAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCacheKeyQueryStringAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleRequestHeaderAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleResponseHeaderAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleRouteConfigurationOverrideAction;
import com.azure.resourcemanager.cdn.models.OriginGroupOverrideAction;
import com.azure.resourcemanager.cdn.models.UrlRedirectAction;
import com.azure.resourcemanager.cdn.models.UrlRewriteAction;
import com.azure.resourcemanager.cdn.models.UrlSigningAction;
import java.io.IOException;

public class DeliveryRuleAction
implements JsonSerializable<DeliveryRuleAction> {
    private DeliveryRuleActionValue name = DeliveryRuleActionValue.fromString("DeliveryRuleAction");

    public DeliveryRuleActionValue name() {
        return this.name;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleAction fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryRuleAction)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DeliveryRuleAction deliveryRuleAction;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("name".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("UrlRedirect".equals(discriminatorValue)) {
                    deliveryRuleAction = UrlRedirectAction.fromJson(readerToUse.reset());
                    return deliveryRuleAction;
                }
                if ("UrlSigning".equals(discriminatorValue)) {
                    deliveryRuleAction = UrlSigningAction.fromJson(readerToUse.reset());
                    return deliveryRuleAction;
                }
                if ("OriginGroupOverride".equals(discriminatorValue)) {
                    deliveryRuleAction = OriginGroupOverrideAction.fromJson(readerToUse.reset());
                    return deliveryRuleAction;
                }
                if ("UrlRewrite".equals(discriminatorValue)) {
                    deliveryRuleAction = UrlRewriteAction.fromJson(readerToUse.reset());
                    return deliveryRuleAction;
                }
                if ("ModifyRequestHeader".equals(discriminatorValue)) {
                    deliveryRuleAction = DeliveryRuleRequestHeaderAction.fromJson(readerToUse.reset());
                    return deliveryRuleAction;
                }
                if ("ModifyResponseHeader".equals(discriminatorValue)) {
                    deliveryRuleAction = DeliveryRuleResponseHeaderAction.fromJson(readerToUse.reset());
                    return deliveryRuleAction;
                }
                if ("CacheExpiration".equals(discriminatorValue)) {
                    deliveryRuleAction = DeliveryRuleCacheExpirationAction.fromJson(readerToUse.reset());
                    return deliveryRuleAction;
                }
                if ("CacheKeyQueryString".equals(discriminatorValue)) {
                    deliveryRuleAction = DeliveryRuleCacheKeyQueryStringAction.fromJson(readerToUse.reset());
                    return deliveryRuleAction;
                }
                if ("RouteConfigurationOverride".equals(discriminatorValue)) {
                    deliveryRuleAction = DeliveryRuleRouteConfigurationOverrideAction.fromJson(readerToUse.reset());
                    return deliveryRuleAction;
                }
                deliveryRuleAction = DeliveryRuleAction.fromJsonKnownDiscriminator(readerToUse.reset());
                return deliveryRuleAction;
            }
        });
    }

    static DeliveryRuleAction fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DeliveryRuleAction)jsonReader.readObject(reader -> {
            DeliveryRuleAction deserializedDeliveryRuleAction = new DeliveryRuleAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleAction.name = DeliveryRuleActionValue.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleAction;
        });
    }
}

