/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.RequestSchemeMatchConditionParametersMatchValuesItem;
import com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class RequestSchemeMatchConditionParameters
implements JsonSerializable<RequestSchemeMatchConditionParameters> {
    private String typeName = "DeliveryRuleRequestSchemeConditionParameters";
    private String operator = "Equal";
    private Boolean negateCondition;
    private List<Transform> transforms;
    private List<RequestSchemeMatchConditionParametersMatchValuesItem> matchValues;

    public String typeName() {
        return this.typeName;
    }

    public RequestSchemeMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String operator() {
        return this.operator;
    }

    public RequestSchemeMatchConditionParameters withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public RequestSchemeMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public RequestSchemeMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public List<RequestSchemeMatchConditionParametersMatchValuesItem> matchValues() {
        return this.matchValues;
    }

    public RequestSchemeMatchConditionParameters withMatchValues(List<RequestSchemeMatchConditionParametersMatchValuesItem> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator);
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static RequestSchemeMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RequestSchemeMatchConditionParameters)jsonReader.readObject(reader -> {
            RequestSchemeMatchConditionParameters deserializedRequestSchemeMatchConditionParameters = new RequestSchemeMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("negateCondition".equals(fieldName)) {
                    deserializedRequestSchemeMatchConditionParameters.negateCondition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List transforms;
                    deserializedRequestSchemeMatchConditionParameters.transforms = transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List matchValues;
                    deserializedRequestSchemeMatchConditionParameters.matchValues = matchValues = reader.readArray(reader1 -> RequestSchemeMatchConditionParametersMatchValuesItem.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestSchemeMatchConditionParameters;
        });
    }
}

