// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A rule that specifies a set of actions and conditions.
 */
@Fluent
public final class DeliveryRule implements JsonSerializable<DeliveryRule> {
    /*
     * Name of the rule
     */
    private String name;

    /*
     * The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser
     * order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not
     * require any condition and actions listed in it will always be applied.
     */
    private int order;

    /*
     * A list of conditions that must be matched for the actions to be executed
     */
    private List<DeliveryRuleCondition> conditions;

    /*
     * A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    private List<DeliveryRuleAction> actions;

    /**
     * Creates an instance of DeliveryRule class.
     */
    public DeliveryRule() {
    }

    /**
     * Get the name property: Name of the rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the rule.
     * 
     * @param name the name value to set.
     * @return the DeliveryRule object itself.
     */
    public DeliveryRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the order property: The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}.
     * A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special
     * rule. It does not require any condition and actions listed in it will always be applied.
     * 
     * @return the order value.
     */
    public int order() {
        return this.order;
    }

    /**
     * Set the order property: The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}.
     * A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special
     * rule. It does not require any condition and actions listed in it will always be applied.
     * 
     * @param order the order value to set.
     * @return the DeliveryRule object itself.
     */
    public DeliveryRule withOrder(int order) {
        this.order = order;
        return this;
    }

    /**
     * Get the conditions property: A list of conditions that must be matched for the actions to be executed.
     * 
     * @return the conditions value.
     */
    public List<DeliveryRuleCondition> conditions() {
        return this.conditions;
    }

    /**
     * Set the conditions property: A list of conditions that must be matched for the actions to be executed.
     * 
     * @param conditions the conditions value to set.
     * @return the DeliveryRule object itself.
     */
    public DeliveryRule withConditions(List<DeliveryRuleCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    /**
     * Get the actions property: A list of actions that are executed when all the conditions of a rule are satisfied.
     * 
     * @return the actions value.
     */
    public List<DeliveryRuleAction> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: A list of actions that are executed when all the conditions of a rule are satisfied.
     * 
     * @param actions the actions value to set.
     * @return the DeliveryRule object itself.
     */
    public DeliveryRule withActions(List<DeliveryRuleAction> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (conditions() != null) {
            conditions().forEach(e -> e.validate());
        }
        if (actions() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property actions in model DeliveryRule"));
        } else {
            actions().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRule.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("order", this.order);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("conditions", this.conditions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeliveryRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeliveryRule if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeliveryRule.
     */
    public static DeliveryRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeliveryRule deserializedDeliveryRule = new DeliveryRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("order".equals(fieldName)) {
                    deserializedDeliveryRule.order = reader.getInt();
                } else if ("actions".equals(fieldName)) {
                    List<DeliveryRuleAction> actions
                        = reader.readArray(reader1 -> DeliveryRuleAction.fromJson(reader1));
                    deserializedDeliveryRule.actions = actions;
                } else if ("name".equals(fieldName)) {
                    deserializedDeliveryRule.name = reader.getString();
                } else if ("conditions".equals(fieldName)) {
                    List<DeliveryRuleCondition> conditions
                        = reader.readArray(reader1 -> DeliveryRuleCondition.fromJson(reader1));
                    deserializedDeliveryRule.conditions = conditions;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeliveryRule;
        });
    }
}
