/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CustomRuleList;
import com.azure.resourcemanager.cdn.models.EndpointResource;
import com.azure.resourcemanager.cdn.models.ManagedRuleSetList;
import com.azure.resourcemanager.cdn.models.PolicyResourceState;
import com.azure.resourcemanager.cdn.models.PolicySettings;
import com.azure.resourcemanager.cdn.models.ProvisioningState;
import com.azure.resourcemanager.cdn.models.RateLimitRuleList;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CdnWebApplicationFirewallPolicyProperties
implements JsonSerializable<CdnWebApplicationFirewallPolicyProperties> {
    private PolicySettings policySettings;
    private RateLimitRuleList rateLimitRules;
    private CustomRuleList customRules;
    private ManagedRuleSetList managedRules;
    private List<EndpointResource> endpointLinks;
    private Map<String, String> extendedProperties;
    private ProvisioningState provisioningState;
    private PolicyResourceState resourceState;

    public PolicySettings policySettings() {
        return this.policySettings;
    }

    public CdnWebApplicationFirewallPolicyProperties withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    public RateLimitRuleList rateLimitRules() {
        return this.rateLimitRules;
    }

    public CdnWebApplicationFirewallPolicyProperties withRateLimitRules(RateLimitRuleList rateLimitRules) {
        this.rateLimitRules = rateLimitRules;
        return this;
    }

    public CustomRuleList customRules() {
        return this.customRules;
    }

    public CdnWebApplicationFirewallPolicyProperties withCustomRules(CustomRuleList customRules) {
        this.customRules = customRules;
        return this;
    }

    public ManagedRuleSetList managedRules() {
        return this.managedRules;
    }

    public CdnWebApplicationFirewallPolicyProperties withManagedRules(ManagedRuleSetList managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    public List<EndpointResource> endpointLinks() {
        return this.endpointLinks;
    }

    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    public CdnWebApplicationFirewallPolicyProperties withExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PolicyResourceState resourceState() {
        return this.resourceState;
    }

    public void validate() {
        if (this.policySettings() != null) {
            this.policySettings().validate();
        }
        if (this.rateLimitRules() != null) {
            this.rateLimitRules().validate();
        }
        if (this.customRules() != null) {
            this.customRules().validate();
        }
        if (this.managedRules() != null) {
            this.managedRules().validate();
        }
        if (this.endpointLinks() != null) {
            this.endpointLinks().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("policySettings", (JsonSerializable)this.policySettings);
        jsonWriter.writeJsonField("rateLimitRules", (JsonSerializable)this.rateLimitRules);
        jsonWriter.writeJsonField("customRules", (JsonSerializable)this.customRules);
        jsonWriter.writeJsonField("managedRules", (JsonSerializable)this.managedRules);
        jsonWriter.writeMapField("extendedProperties", this.extendedProperties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CdnWebApplicationFirewallPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CdnWebApplicationFirewallPolicyProperties)jsonReader.readObject(reader -> {
            CdnWebApplicationFirewallPolicyProperties deserializedCdnWebApplicationFirewallPolicyProperties = new CdnWebApplicationFirewallPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policySettings".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.policySettings = PolicySettings.fromJson(reader);
                    continue;
                }
                if ("rateLimitRules".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.rateLimitRules = RateLimitRuleList.fromJson(reader);
                    continue;
                }
                if ("customRules".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.customRules = CustomRuleList.fromJson(reader);
                    continue;
                }
                if ("managedRules".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.managedRules = ManagedRuleSetList.fromJson(reader);
                    continue;
                }
                if ("endpointLinks".equals(fieldName)) {
                    List endpointLinks;
                    deserializedCdnWebApplicationFirewallPolicyProperties.endpointLinks = endpointLinks = reader.readArray(reader1 -> EndpointResource.fromJson(reader1));
                    continue;
                }
                if ("extendedProperties".equals(fieldName)) {
                    Map extendedProperties;
                    deserializedCdnWebApplicationFirewallPolicyProperties.extendedProperties = extendedProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceState".equals(fieldName)) {
                    deserializedCdnWebApplicationFirewallPolicyProperties.resourceState = PolicyResourceState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCdnWebApplicationFirewallPolicyProperties;
        });
    }
}

