/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeliveryRule;
import java.io.IOException;
import java.util.List;

public final class EndpointPropertiesUpdateParametersDeliveryPolicy
implements JsonSerializable<EndpointPropertiesUpdateParametersDeliveryPolicy> {
    private String description;
    private List<DeliveryRule> rules;
    private static final ClientLogger LOGGER = new ClientLogger(EndpointPropertiesUpdateParametersDeliveryPolicy.class);

    public String description() {
        return this.description;
    }

    public EndpointPropertiesUpdateParametersDeliveryPolicy withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<DeliveryRule> rules() {
        return this.rules;
    }

    public EndpointPropertiesUpdateParametersDeliveryPolicy withRules(List<DeliveryRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.rules() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rules in model EndpointPropertiesUpdateParametersDeliveryPolicy"));
        }
        this.rules().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static EndpointPropertiesUpdateParametersDeliveryPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (EndpointPropertiesUpdateParametersDeliveryPolicy)jsonReader.readObject(reader -> {
            EndpointPropertiesUpdateParametersDeliveryPolicy deserializedEndpointPropertiesUpdateParametersDeliveryPolicy = new EndpointPropertiesUpdateParametersDeliveryPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedEndpointPropertiesUpdateParametersDeliveryPolicy.rules = rules = reader.readArray(reader1 -> DeliveryRule.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedEndpointPropertiesUpdateParametersDeliveryPolicy.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpointPropertiesUpdateParametersDeliveryPolicy;
        });
    }
}

