// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The JSON object that contains the properties to secure a domain.
 */
@Fluent
public final class AfdDomainHttpsParameters implements JsonSerializable<AfdDomainHttpsParameters> {
    /*
     * Defines the source of the SSL certificate.
     */
    private AfdCertificateType certificateType;

    /*
     * TLS protocol version that will be used for Https
     */
    private AfdMinimumTlsVersion minimumTlsVersion;

    /*
     * Resource reference to the secret. ie. subs/rg/profile/secret
     */
    private ResourceReference secret;

    /**
     * Creates an instance of AfdDomainHttpsParameters class.
     */
    public AfdDomainHttpsParameters() {
    }

    /**
     * Get the certificateType property: Defines the source of the SSL certificate.
     * 
     * @return the certificateType value.
     */
    public AfdCertificateType certificateType() {
        return this.certificateType;
    }

    /**
     * Set the certificateType property: Defines the source of the SSL certificate.
     * 
     * @param certificateType the certificateType value to set.
     * @return the AfdDomainHttpsParameters object itself.
     */
    public AfdDomainHttpsParameters withCertificateType(AfdCertificateType certificateType) {
        this.certificateType = certificateType;
        return this;
    }

    /**
     * Get the minimumTlsVersion property: TLS protocol version that will be used for Https.
     * 
     * @return the minimumTlsVersion value.
     */
    public AfdMinimumTlsVersion minimumTlsVersion() {
        return this.minimumTlsVersion;
    }

    /**
     * Set the minimumTlsVersion property: TLS protocol version that will be used for Https.
     * 
     * @param minimumTlsVersion the minimumTlsVersion value to set.
     * @return the AfdDomainHttpsParameters object itself.
     */
    public AfdDomainHttpsParameters withMinimumTlsVersion(AfdMinimumTlsVersion minimumTlsVersion) {
        this.minimumTlsVersion = minimumTlsVersion;
        return this;
    }

    /**
     * Get the secret property: Resource reference to the secret. ie. subs/rg/profile/secret.
     * 
     * @return the secret value.
     */
    public ResourceReference secret() {
        return this.secret;
    }

    /**
     * Set the secret property: Resource reference to the secret. ie. subs/rg/profile/secret.
     * 
     * @param secret the secret value to set.
     * @return the AfdDomainHttpsParameters object itself.
     */
    public AfdDomainHttpsParameters withSecret(ResourceReference secret) {
        this.secret = secret;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (certificateType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property certificateType in model AfdDomainHttpsParameters"));
        }
        if (secret() != null) {
            secret().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AfdDomainHttpsParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("certificateType",
            this.certificateType == null ? null : this.certificateType.toString());
        jsonWriter.writeStringField("minimumTlsVersion",
            this.minimumTlsVersion == null ? null : this.minimumTlsVersion.toString());
        jsonWriter.writeJsonField("secret", this.secret);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AfdDomainHttpsParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AfdDomainHttpsParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AfdDomainHttpsParameters.
     */
    public static AfdDomainHttpsParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AfdDomainHttpsParameters deserializedAfdDomainHttpsParameters = new AfdDomainHttpsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("certificateType".equals(fieldName)) {
                    deserializedAfdDomainHttpsParameters.certificateType
                        = AfdCertificateType.fromString(reader.getString());
                } else if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedAfdDomainHttpsParameters.minimumTlsVersion
                        = AfdMinimumTlsVersion.fromString(reader.getString());
                } else if ("secret".equals(fieldName)) {
                    deserializedAfdDomainHttpsParameters.secret = ResourceReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAfdDomainHttpsParameters;
        });
    }
}
