// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.SecurityPolicyInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list security policies. It contains a list of security policy objects and a URL link to get
 * the next set of results.
 */
@Fluent
public final class SecurityPolicyListResult implements JsonSerializable<SecurityPolicyListResult> {
    /*
     * List of Security policies within a profile
     */
    private List<SecurityPolicyInner> value;

    /*
     * URL to get the next set of security policy objects if there is any.
     */
    private String nextLink;

    /**
     * Creates an instance of SecurityPolicyListResult class.
     */
    public SecurityPolicyListResult() {
    }

    /**
     * Get the value property: List of Security policies within a profile.
     * 
     * @return the value value.
     */
    public List<SecurityPolicyInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of security policy objects if there is any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of security policy objects if there is any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SecurityPolicyListResult object itself.
     */
    public SecurityPolicyListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityPolicyListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityPolicyListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityPolicyListResult.
     */
    public static SecurityPolicyListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityPolicyListResult deserializedSecurityPolicyListResult = new SecurityPolicyListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SecurityPolicyInner> value
                        = reader.readArray(reader1 -> SecurityPolicyInner.fromJson(reader1));
                    deserializedSecurityPolicyListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSecurityPolicyListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityPolicyListResult;
        });
    }
}
