/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.RequestMethodMatchConditionParametersMatchValuesItem;
import com.azure.resourcemanager.cdn.models.RequestMethodOperator;
import com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class RequestMethodMatchConditionParameters
implements JsonSerializable<RequestMethodMatchConditionParameters> {
    private String typeName = "DeliveryRuleRequestMethodConditionParameters";
    private RequestMethodOperator operator;
    private Boolean negateCondition;
    private List<Transform> transforms;
    private List<RequestMethodMatchConditionParametersMatchValuesItem> matchValues;
    private static final ClientLogger LOGGER = new ClientLogger(RequestMethodMatchConditionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public RequestMethodMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public RequestMethodOperator operator() {
        return this.operator;
    }

    public RequestMethodMatchConditionParameters withOperator(RequestMethodOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public RequestMethodMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public RequestMethodMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public List<RequestMethodMatchConditionParametersMatchValuesItem> matchValues() {
        return this.matchValues;
    }

    public RequestMethodMatchConditionParameters withMatchValues(List<RequestMethodMatchConditionParametersMatchValuesItem> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model RequestMethodMatchConditionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static RequestMethodMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RequestMethodMatchConditionParameters)jsonReader.readObject(reader -> {
            RequestMethodMatchConditionParameters deserializedRequestMethodMatchConditionParameters = new RequestMethodMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedRequestMethodMatchConditionParameters.operator = RequestMethodOperator.fromString(reader.getString());
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedRequestMethodMatchConditionParameters.negateCondition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List transforms;
                    deserializedRequestMethodMatchConditionParameters.transforms = transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List matchValues;
                    deserializedRequestMethodMatchConditionParameters.matchValues = matchValues = reader.readArray(reader1 -> RequestMethodMatchConditionParametersMatchValuesItem.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRequestMethodMatchConditionParameters;
        });
    }
}

