// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ManagedRuleGroupDefinition;
import java.io.IOException;
import java.util.List;

/**
 * Properties for a managed rule set definition.
 */
@Immutable
public final class ManagedRuleSetDefinitionProperties implements JsonSerializable<ManagedRuleSetDefinitionProperties> {
    /*
     * Provisioning state of the managed rule set.
     */
    private String provisioningState;

    /*
     * Type of the managed rule set.
     */
    private String ruleSetType;

    /*
     * Version of the managed rule set type.
     */
    private String ruleSetVersion;

    /*
     * Rule groups of the managed rule set.
     */
    private List<ManagedRuleGroupDefinition> ruleGroups;

    /**
     * Creates an instance of ManagedRuleSetDefinitionProperties class.
     */
    public ManagedRuleSetDefinitionProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning state of the managed rule set.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the ruleSetType property: Type of the managed rule set.
     * 
     * @return the ruleSetType value.
     */
    public String ruleSetType() {
        return this.ruleSetType;
    }

    /**
     * Get the ruleSetVersion property: Version of the managed rule set type.
     * 
     * @return the ruleSetVersion value.
     */
    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    /**
     * Get the ruleGroups property: Rule groups of the managed rule set.
     * 
     * @return the ruleGroups value.
     */
    public List<ManagedRuleGroupDefinition> ruleGroups() {
        return this.ruleGroups;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleGroups() != null) {
            ruleGroups().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedRuleSetDefinitionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedRuleSetDefinitionProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedRuleSetDefinitionProperties.
     */
    public static ManagedRuleSetDefinitionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedRuleSetDefinitionProperties deserializedManagedRuleSetDefinitionProperties
                = new ManagedRuleSetDefinitionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedRuleSetDefinitionProperties.provisioningState = reader.getString();
                } else if ("ruleSetType".equals(fieldName)) {
                    deserializedManagedRuleSetDefinitionProperties.ruleSetType = reader.getString();
                } else if ("ruleSetVersion".equals(fieldName)) {
                    deserializedManagedRuleSetDefinitionProperties.ruleSetVersion = reader.getString();
                } else if ("ruleGroups".equals(fieldName)) {
                    List<ManagedRuleGroupDefinition> ruleGroups
                        = reader.readArray(reader1 -> ManagedRuleGroupDefinition.fromJson(reader1));
                    deserializedManagedRuleSetDefinitionProperties.ruleGroups = ruleGroups;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedRuleSetDefinitionProperties;
        });
    }
}
