// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.AfdOriginGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list origin groups. It contains a list of origin groups objects and a URL link to get the
 * next set of results.
 */
@Fluent
public final class AfdOriginGroupListResult implements JsonSerializable<AfdOriginGroupListResult> {
    /*
     * List of Azure Front Door origin groups within an Azure Front Door endpoint
     */
    private List<AfdOriginGroupInner> value;

    /*
     * URL to get the next set of origin objects if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of AfdOriginGroupListResult class.
     */
    public AfdOriginGroupListResult() {
    }

    /**
     * Get the value property: List of Azure Front Door origin groups within an Azure Front Door endpoint.
     * 
     * @return the value value.
     */
    public List<AfdOriginGroupInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of origin objects if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of origin objects if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the AfdOriginGroupListResult object itself.
     */
    public AfdOriginGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AfdOriginGroupListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AfdOriginGroupListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AfdOriginGroupListResult.
     */
    public static AfdOriginGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AfdOriginGroupListResult deserializedAfdOriginGroupListResult = new AfdOriginGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AfdOriginGroupInner> value
                        = reader.readArray(reader1 -> AfdOriginGroupInner.fromJson(reader1));
                    deserializedAfdOriginGroupListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedAfdOriginGroupListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAfdOriginGroupListResult;
        });
    }
}
