// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
 */
@Fluent
public final class UserManagedHttpsParameters extends CustomDomainHttpsParameters {
    /*
     * Defines the source of the SSL certificate.
     */
    private CertificateSource certificateSource = CertificateSource.AZURE_KEY_VAULT;

    /*
     * Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
     */
    private KeyVaultCertificateSourceParameters certificateSourceParameters;

    /**
     * Creates an instance of UserManagedHttpsParameters class.
     */
    public UserManagedHttpsParameters() {
    }

    /**
     * Get the certificateSource property: Defines the source of the SSL certificate.
     * 
     * @return the certificateSource value.
     */
    @Override
    public CertificateSource certificateSource() {
        return this.certificateSource;
    }

    /**
     * Get the certificateSourceParameters property: Defines the certificate source parameters using user's keyvault
     * certificate for enabling SSL.
     * 
     * @return the certificateSourceParameters value.
     */
    public KeyVaultCertificateSourceParameters certificateSourceParameters() {
        return this.certificateSourceParameters;
    }

    /**
     * Set the certificateSourceParameters property: Defines the certificate source parameters using user's keyvault
     * certificate for enabling SSL.
     * 
     * @param certificateSourceParameters the certificateSourceParameters value to set.
     * @return the UserManagedHttpsParameters object itself.
     */
    public UserManagedHttpsParameters
        withCertificateSourceParameters(KeyVaultCertificateSourceParameters certificateSourceParameters) {
        this.certificateSourceParameters = certificateSourceParameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public UserManagedHttpsParameters withProtocolType(ProtocolType protocolType) {
        super.withProtocolType(protocolType);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public UserManagedHttpsParameters withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        super.withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (certificateSourceParameters() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property certificateSourceParameters in model UserManagedHttpsParameters"));
        } else {
            certificateSourceParameters().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UserManagedHttpsParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("protocolType", protocolType() == null ? null : protocolType().toString());
        jsonWriter.writeStringField("minimumTlsVersion",
            minimumTlsVersion() == null ? null : minimumTlsVersion().toString());
        jsonWriter.writeJsonField("certificateSourceParameters", this.certificateSourceParameters);
        jsonWriter.writeStringField("certificateSource",
            this.certificateSource == null ? null : this.certificateSource.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserManagedHttpsParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserManagedHttpsParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UserManagedHttpsParameters.
     */
    public static UserManagedHttpsParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserManagedHttpsParameters deserializedUserManagedHttpsParameters = new UserManagedHttpsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("protocolType".equals(fieldName)) {
                    deserializedUserManagedHttpsParameters
                        .withProtocolType(ProtocolType.fromString(reader.getString()));
                } else if ("minimumTlsVersion".equals(fieldName)) {
                    deserializedUserManagedHttpsParameters
                        .withMinimumTlsVersion(MinimumTlsVersion.fromString(reader.getString()));
                } else if ("certificateSourceParameters".equals(fieldName)) {
                    deserializedUserManagedHttpsParameters.certificateSourceParameters
                        = KeyVaultCertificateSourceParameters.fromJson(reader);
                } else if ("certificateSource".equals(fieldName)) {
                    deserializedUserManagedHttpsParameters.certificateSource
                        = CertificateSource.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserManagedHttpsParameters;
        });
    }
}
