// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The MetricsResponseSeriesItemData model.
 */
@Fluent
public final class MetricsResponseSeriesItemData implements JsonSerializable<MetricsResponseSeriesItemData> {
    /*
     * The dateTime property.
     */
    private OffsetDateTime dateTime;

    /*
     * The value property.
     */
    private Float value;

    /**
     * Creates an instance of MetricsResponseSeriesItemData class.
     */
    public MetricsResponseSeriesItemData() {
    }

    /**
     * Get the dateTime property: The dateTime property.
     * 
     * @return the dateTime value.
     */
    public OffsetDateTime dateTime() {
        return this.dateTime;
    }

    /**
     * Set the dateTime property: The dateTime property.
     * 
     * @param dateTime the dateTime value to set.
     * @return the MetricsResponseSeriesItemData object itself.
     */
    public MetricsResponseSeriesItemData withDateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    /**
     * Get the value property: The value property.
     * 
     * @return the value value.
     */
    public Float value() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     * 
     * @param value the value value to set.
     * @return the MetricsResponseSeriesItemData object itself.
     */
    public MetricsResponseSeriesItemData withValue(Float value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dateTime",
            this.dateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.dateTime));
        jsonWriter.writeNumberField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricsResponseSeriesItemData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricsResponseSeriesItemData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricsResponseSeriesItemData.
     */
    public static MetricsResponseSeriesItemData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricsResponseSeriesItemData deserializedMetricsResponseSeriesItemData
                = new MetricsResponseSeriesItemData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dateTime".equals(fieldName)) {
                    deserializedMetricsResponseSeriesItemData.dateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("value".equals(fieldName)) {
                    deserializedMetricsResponseSeriesItemData.value = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricsResponseSeriesItemData;
        });
    }
}
