// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the parameters for the origin group override configuration.
 */
@Fluent
public final class OriginGroupOverride implements JsonSerializable<OriginGroupOverride> {
    /*
     * defines the OriginGroup that would override the DefaultOriginGroup on route.
     */
    private ResourceReference originGroup;

    /*
     * Protocol this rule will use when forwarding traffic to backends.
     */
    private ForwardingProtocol forwardingProtocol;

    /**
     * Creates an instance of OriginGroupOverride class.
     */
    public OriginGroupOverride() {
    }

    /**
     * Get the originGroup property: defines the OriginGroup that would override the DefaultOriginGroup on route.
     * 
     * @return the originGroup value.
     */
    public ResourceReference originGroup() {
        return this.originGroup;
    }

    /**
     * Set the originGroup property: defines the OriginGroup that would override the DefaultOriginGroup on route.
     * 
     * @param originGroup the originGroup value to set.
     * @return the OriginGroupOverride object itself.
     */
    public OriginGroupOverride withOriginGroup(ResourceReference originGroup) {
        this.originGroup = originGroup;
        return this;
    }

    /**
     * Get the forwardingProtocol property: Protocol this rule will use when forwarding traffic to backends.
     * 
     * @return the forwardingProtocol value.
     */
    public ForwardingProtocol forwardingProtocol() {
        return this.forwardingProtocol;
    }

    /**
     * Set the forwardingProtocol property: Protocol this rule will use when forwarding traffic to backends.
     * 
     * @param forwardingProtocol the forwardingProtocol value to set.
     * @return the OriginGroupOverride object itself.
     */
    public OriginGroupOverride withForwardingProtocol(ForwardingProtocol forwardingProtocol) {
        this.forwardingProtocol = forwardingProtocol;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (originGroup() != null) {
            originGroup().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("originGroup", this.originGroup);
        jsonWriter.writeStringField("forwardingProtocol",
            this.forwardingProtocol == null ? null : this.forwardingProtocol.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OriginGroupOverride from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OriginGroupOverride if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OriginGroupOverride.
     */
    public static OriginGroupOverride fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OriginGroupOverride deserializedOriginGroupOverride = new OriginGroupOverride();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("originGroup".equals(fieldName)) {
                    deserializedOriginGroupOverride.originGroup = ResourceReference.fromJson(reader);
                } else if ("forwardingProtocol".equals(fieldName)) {
                    deserializedOriginGroupOverride.forwardingProtocol
                        = ForwardingProtocol.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOriginGroupOverride;
        });
    }
}
