// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters required for content purge.
 */
@Fluent
public final class PurgeParameters implements JsonSerializable<PurgeParameters> {
    /*
     * The path to the content to be purged. Can describe a file path or a wild card directory.
     */
    private List<String> contentPaths;

    /**
     * Creates an instance of PurgeParameters class.
     */
    public PurgeParameters() {
    }

    /**
     * Get the contentPaths property: The path to the content to be purged. Can describe a file path or a wild card
     * directory.
     * 
     * @return the contentPaths value.
     */
    public List<String> contentPaths() {
        return this.contentPaths;
    }

    /**
     * Set the contentPaths property: The path to the content to be purged. Can describe a file path or a wild card
     * directory.
     * 
     * @param contentPaths the contentPaths value to set.
     * @return the PurgeParameters object itself.
     */
    public PurgeParameters withContentPaths(List<String> contentPaths) {
        this.contentPaths = contentPaths;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (contentPaths() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property contentPaths in model PurgeParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PurgeParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("contentPaths", this.contentPaths, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PurgeParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PurgeParameters if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PurgeParameters.
     */
    public static PurgeParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PurgeParameters deserializedPurgeParameters = new PurgeParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("contentPaths".equals(fieldName)) {
                    List<String> contentPaths = reader.readArray(reader1 -> reader1.getString());
                    deserializedPurgeParameters.contentPaths = contentPaths;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPurgeParameters;
        });
    }
}
