// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The JSON object that contains the properties to determine origin health using real requests/responses.
 */
@Fluent
public final class ResponseBasedOriginErrorDetectionParameters
    implements JsonSerializable<ResponseBasedOriginErrorDetectionParameters> {
    /*
     * Type of response errors for real user requests for which origin will be deemed unhealthy
     */
    private ResponseBasedDetectedErrorTypes responseBasedDetectedErrorTypes;

    /*
     * The percentage of failed requests in the sample where failover should trigger.
     */
    private Integer responseBasedFailoverThresholdPercentage;

    /*
     * The list of Http status code ranges that are considered as server errors for origin and it is marked as
     * unhealthy.
     */
    private List<HttpErrorRangeParameters> httpErrorRanges;

    /**
     * Creates an instance of ResponseBasedOriginErrorDetectionParameters class.
     */
    public ResponseBasedOriginErrorDetectionParameters() {
    }

    /**
     * Get the responseBasedDetectedErrorTypes property: Type of response errors for real user requests for which origin
     * will be deemed unhealthy.
     * 
     * @return the responseBasedDetectedErrorTypes value.
     */
    public ResponseBasedDetectedErrorTypes responseBasedDetectedErrorTypes() {
        return this.responseBasedDetectedErrorTypes;
    }

    /**
     * Set the responseBasedDetectedErrorTypes property: Type of response errors for real user requests for which origin
     * will be deemed unhealthy.
     * 
     * @param responseBasedDetectedErrorTypes the responseBasedDetectedErrorTypes value to set.
     * @return the ResponseBasedOriginErrorDetectionParameters object itself.
     */
    public ResponseBasedOriginErrorDetectionParameters
        withResponseBasedDetectedErrorTypes(ResponseBasedDetectedErrorTypes responseBasedDetectedErrorTypes) {
        this.responseBasedDetectedErrorTypes = responseBasedDetectedErrorTypes;
        return this;
    }

    /**
     * Get the responseBasedFailoverThresholdPercentage property: The percentage of failed requests in the sample where
     * failover should trigger.
     * 
     * @return the responseBasedFailoverThresholdPercentage value.
     */
    public Integer responseBasedFailoverThresholdPercentage() {
        return this.responseBasedFailoverThresholdPercentage;
    }

    /**
     * Set the responseBasedFailoverThresholdPercentage property: The percentage of failed requests in the sample where
     * failover should trigger.
     * 
     * @param responseBasedFailoverThresholdPercentage the responseBasedFailoverThresholdPercentage value to set.
     * @return the ResponseBasedOriginErrorDetectionParameters object itself.
     */
    public ResponseBasedOriginErrorDetectionParameters
        withResponseBasedFailoverThresholdPercentage(Integer responseBasedFailoverThresholdPercentage) {
        this.responseBasedFailoverThresholdPercentage = responseBasedFailoverThresholdPercentage;
        return this;
    }

    /**
     * Get the httpErrorRanges property: The list of Http status code ranges that are considered as server errors for
     * origin and it is marked as unhealthy.
     * 
     * @return the httpErrorRanges value.
     */
    public List<HttpErrorRangeParameters> httpErrorRanges() {
        return this.httpErrorRanges;
    }

    /**
     * Set the httpErrorRanges property: The list of Http status code ranges that are considered as server errors for
     * origin and it is marked as unhealthy.
     * 
     * @param httpErrorRanges the httpErrorRanges value to set.
     * @return the ResponseBasedOriginErrorDetectionParameters object itself.
     */
    public ResponseBasedOriginErrorDetectionParameters
        withHttpErrorRanges(List<HttpErrorRangeParameters> httpErrorRanges) {
        this.httpErrorRanges = httpErrorRanges;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (httpErrorRanges() != null) {
            httpErrorRanges().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("responseBasedDetectedErrorTypes",
            this.responseBasedDetectedErrorTypes == null ? null : this.responseBasedDetectedErrorTypes.toString());
        jsonWriter.writeNumberField("responseBasedFailoverThresholdPercentage",
            this.responseBasedFailoverThresholdPercentage);
        jsonWriter.writeArrayField("httpErrorRanges", this.httpErrorRanges,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponseBasedOriginErrorDetectionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponseBasedOriginErrorDetectionParameters if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResponseBasedOriginErrorDetectionParameters.
     */
    public static ResponseBasedOriginErrorDetectionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponseBasedOriginErrorDetectionParameters deserializedResponseBasedOriginErrorDetectionParameters
                = new ResponseBasedOriginErrorDetectionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("responseBasedDetectedErrorTypes".equals(fieldName)) {
                    deserializedResponseBasedOriginErrorDetectionParameters.responseBasedDetectedErrorTypes
                        = ResponseBasedDetectedErrorTypes.fromString(reader.getString());
                } else if ("responseBasedFailoverThresholdPercentage".equals(fieldName)) {
                    deserializedResponseBasedOriginErrorDetectionParameters.responseBasedFailoverThresholdPercentage
                        = reader.getNullable(JsonReader::getInt);
                } else if ("httpErrorRanges".equals(fieldName)) {
                    List<HttpErrorRangeParameters> httpErrorRanges
                        = reader.readArray(reader1 -> HttpErrorRangeParameters.fromJson(reader1));
                    deserializedResponseBasedOriginErrorDetectionParameters.httpErrorRanges = httpErrorRanges;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResponseBasedOriginErrorDetectionParameters;
        });
    }
}
