// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.SecurityPolicyUpdateProperties;
import java.io.IOException;

/**
 * The JSON object containing security policy update parameters.
 */
@Fluent
public final class SecurityPolicyUpdateParameters implements JsonSerializable<SecurityPolicyUpdateParameters> {
    /*
     * The json object that contains properties required to update a security policy
     */
    private SecurityPolicyUpdateProperties innerProperties;

    /**
     * Creates an instance of SecurityPolicyUpdateParameters class.
     */
    public SecurityPolicyUpdateParameters() {
    }

    /**
     * Get the innerProperties property: The json object that contains properties required to update a security policy.
     * 
     * @return the innerProperties value.
     */
    private SecurityPolicyUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the parameters property: object which contains security policy parameters.
     * 
     * @return the parameters value.
     */
    public SecurityPolicyPropertiesParameters parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    /**
     * Set the parameters property: object which contains security policy parameters.
     * 
     * @param parameters the parameters value to set.
     * @return the SecurityPolicyUpdateParameters object itself.
     */
    public SecurityPolicyUpdateParameters withParameters(SecurityPolicyPropertiesParameters parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityPolicyUpdateProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityPolicyUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityPolicyUpdateParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityPolicyUpdateParameters.
     */
    public static SecurityPolicyUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityPolicyUpdateParameters deserializedSecurityPolicyUpdateParameters
                = new SecurityPolicyUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedSecurityPolicyUpdateParameters.innerProperties
                        = SecurityPolicyUpdateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityPolicyUpdateParameters;
        });
    }
}
