// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines how to identify a parameter for a specific purpose e.g. expires.
 */
@Fluent
public final class UrlSigningParamIdentifier implements JsonSerializable<UrlSigningParamIdentifier> {
    /*
     * Indicates the purpose of the parameter
     */
    private ParamIndicator paramIndicator;

    /*
     * Parameter name
     */
    private String paramName;

    /**
     * Creates an instance of UrlSigningParamIdentifier class.
     */
    public UrlSigningParamIdentifier() {
    }

    /**
     * Get the paramIndicator property: Indicates the purpose of the parameter.
     * 
     * @return the paramIndicator value.
     */
    public ParamIndicator paramIndicator() {
        return this.paramIndicator;
    }

    /**
     * Set the paramIndicator property: Indicates the purpose of the parameter.
     * 
     * @param paramIndicator the paramIndicator value to set.
     * @return the UrlSigningParamIdentifier object itself.
     */
    public UrlSigningParamIdentifier withParamIndicator(ParamIndicator paramIndicator) {
        this.paramIndicator = paramIndicator;
        return this;
    }

    /**
     * Get the paramName property: Parameter name.
     * 
     * @return the paramName value.
     */
    public String paramName() {
        return this.paramName;
    }

    /**
     * Set the paramName property: Parameter name.
     * 
     * @param paramName the paramName value to set.
     * @return the UrlSigningParamIdentifier object itself.
     */
    public UrlSigningParamIdentifier withParamName(String paramName) {
        this.paramName = paramName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (paramIndicator() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property paramIndicator in model UrlSigningParamIdentifier"));
        }
        if (paramName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property paramName in model UrlSigningParamIdentifier"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(UrlSigningParamIdentifier.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("paramIndicator",
            this.paramIndicator == null ? null : this.paramIndicator.toString());
        jsonWriter.writeStringField("paramName", this.paramName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UrlSigningParamIdentifier from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UrlSigningParamIdentifier if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the UrlSigningParamIdentifier.
     */
    public static UrlSigningParamIdentifier fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UrlSigningParamIdentifier deserializedUrlSigningParamIdentifier = new UrlSigningParamIdentifier();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("paramIndicator".equals(fieldName)) {
                    deserializedUrlSigningParamIdentifier.paramIndicator
                        = ParamIndicator.fromString(reader.getString());
                } else if ("paramName".equals(fieldName)) {
                    deserializedUrlSigningParamIdentifier.paramName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUrlSigningParamIdentifier;
        });
    }
}
