// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.AfdDomainHttpsParameters;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.DomainValidationProperties;
import com.azure.resourcemanager.cdn.models.DomainValidationState;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SystemData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g.
 * www.contoso.com.
 */
@JsonFlatten
@Fluent
public class AfdDomainInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AfdDomainInner.class);

    /*
     * The configuration specifying how to enable HTTPS for the domain - using
     * AzureFrontDoor managed certificate or user's own certificate. If not
     * specified, enabling ssl uses AzureFrontDoor managed certificate by
     * default.
     */
    @JsonProperty(value = "properties.tlsSettings")
    private AfdDomainHttpsParameters tlsSettings;

    /*
     * Resource reference to the Azure DNS zone
     */
    @JsonProperty(value = "properties.azureDnsZone")
    private ResourceReference azureDnsZone;

    /*
     * Provisioning status
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;

    /*
     * The deploymentStatus property.
     */
    @JsonProperty(value = "properties.deploymentStatus", access = JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;

    /*
     * Provisioning substate shows the progress of custom HTTPS
     * enabling/disabling process step by step. DCV stands for
     * DomainControlValidation.
     */
    @JsonProperty(value = "properties.domainValidationState", access = JsonProperty.Access.WRITE_ONLY)
    private DomainValidationState domainValidationState;

    /*
     * The host name of the domain. Must be a domain name.
     */
    @JsonProperty(value = "properties.hostName")
    private String hostname;

    /*
     * Values the customer needs to validate domain ownership
     */
    @JsonProperty(value = "properties.validationProperties", access = JsonProperty.Access.WRITE_ONLY)
    private DomainValidationProperties validationProperties;

    /*
     * Read only system data
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get the tlsSettings property: The configuration specifying how to enable HTTPS for the domain - using
     * AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor
     * managed certificate by default.
     *
     * @return the tlsSettings value.
     */
    public AfdDomainHttpsParameters tlsSettings() {
        return this.tlsSettings;
    }

    /**
     * Set the tlsSettings property: The configuration specifying how to enable HTTPS for the domain - using
     * AzureFrontDoor managed certificate or user's own certificate. If not specified, enabling ssl uses AzureFrontDoor
     * managed certificate by default.
     *
     * @param tlsSettings the tlsSettings value to set.
     * @return the AfdDomainInner object itself.
     */
    public AfdDomainInner withTlsSettings(AfdDomainHttpsParameters tlsSettings) {
        this.tlsSettings = tlsSettings;
        return this;
    }

    /**
     * Get the azureDnsZone property: Resource reference to the Azure DNS zone.
     *
     * @return the azureDnsZone value.
     */
    public ResourceReference azureDnsZone() {
        return this.azureDnsZone;
    }

    /**
     * Set the azureDnsZone property: Resource reference to the Azure DNS zone.
     *
     * @param azureDnsZone the azureDnsZone value to set.
     * @return the AfdDomainInner object itself.
     */
    public AfdDomainInner withAzureDnsZone(ResourceReference azureDnsZone) {
        this.azureDnsZone = azureDnsZone;
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning status.
     *
     * @return the provisioningState value.
     */
    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the deploymentStatus property: The deploymentStatus property.
     *
     * @return the deploymentStatus value.
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    /**
     * Get the domainValidationState property: Provisioning substate shows the progress of custom HTTPS
     * enabling/disabling process step by step. DCV stands for DomainControlValidation.
     *
     * @return the domainValidationState value.
     */
    public DomainValidationState domainValidationState() {
        return this.domainValidationState;
    }

    /**
     * Get the hostname property: The host name of the domain. Must be a domain name.
     *
     * @return the hostname value.
     */
    public String hostname() {
        return this.hostname;
    }

    /**
     * Set the hostname property: The host name of the domain. Must be a domain name.
     *
     * @param hostname the hostname value to set.
     * @return the AfdDomainInner object itself.
     */
    public AfdDomainInner withHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    /**
     * Get the validationProperties property: Values the customer needs to validate domain ownership.
     *
     * @return the validationProperties value.
     */
    public DomainValidationProperties validationProperties() {
        return this.validationProperties;
    }

    /**
     * Get the systemData property: Read only system data.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tlsSettings() != null) {
            tlsSettings().validate();
        }
        if (azureDnsZone() != null) {
            azureDnsZone().validate();
        }
        if (validationProperties() != null) {
            validationProperties().validate();
        }
        if (systemData() != null) {
            systemData().validate();
        }
    }
}
