// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Defines the parameters for the origin group override action. */
@Fluent
public final class OriginGroupOverrideActionParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(OriginGroupOverrideActionParameters.class);

    /*
     * The @odata.type property.
     */
    @JsonProperty(value = "@odata.type", required = true)
    private String odataType;

    /*
     * defines the OriginGroup that would override the DefaultOriginGroup.
     */
    @JsonProperty(value = "originGroup", required = true)
    private ResourceReference originGroup;

    /** Creates an instance of OriginGroupOverrideActionParameters class. */
    public OriginGroupOverrideActionParameters() {
        odataType = "#Microsoft.Azure.Cdn.Models.DeliveryRuleOriginGroupOverrideActionParameters";
    }

    /**
     * Get the odataType property: The @odata.type property.
     *
     * @return the odataType value.
     */
    public String odataType() {
        return this.odataType;
    }

    /**
     * Set the odataType property: The @odata.type property.
     *
     * @param odataType the odataType value to set.
     * @return the OriginGroupOverrideActionParameters object itself.
     */
    public OriginGroupOverrideActionParameters withOdataType(String odataType) {
        this.odataType = odataType;
        return this;
    }

    /**
     * Get the originGroup property: defines the OriginGroup that would override the DefaultOriginGroup.
     *
     * @return the originGroup value.
     */
    public ResourceReference originGroup() {
        return this.originGroup;
    }

    /**
     * Set the originGroup property: defines the OriginGroup that would override the DefaultOriginGroup.
     *
     * @param originGroup the originGroup value to set.
     * @return the OriginGroupOverrideActionParameters object itself.
     */
    public OriginGroupOverrideActionParameters withOriginGroup(ResourceReference originGroup) {
        this.originGroup = originGroup;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (originGroup() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property originGroup in model OriginGroupOverrideActionParameters"));
        } else {
            originGroup().validate();
        }
    }
}
