// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The JSON object that contains the properties of the Secret to create. */
@Fluent
public final class SecretProperties extends AfdStateProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SecretProperties.class);

    /*
     * object which contains secret parameters
     */
    @JsonProperty(value = "parameters")
    private SecretParameters parameters;

    /**
     * Get the parameters property: object which contains secret parameters.
     *
     * @return the parameters value.
     */
    public SecretParameters parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: object which contains secret parameters.
     *
     * @param parameters the parameters value to set.
     * @return the SecretProperties object itself.
     */
    public SecretProperties withParameters(SecretParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (parameters() != null) {
            parameters().validate();
        }
    }
}
