/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.LoadBalancingSettingsParameters;
import com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import com.azure.resourcemanager.cdn.models.SystemData;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonFlatten
public class AfdOriginGroupInner
extends ProxyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AfdOriginGroupInner.class);
    @JsonProperty(value="properties.loadBalancingSettings")
    private LoadBalancingSettingsParameters loadBalancingSettings;
    @JsonProperty(value="properties.healthProbeSettings")
    private HealthProbeParameters healthProbeSettings;
    @JsonProperty(value="properties.trafficRestorationTimeToHealedOrNewEndpointsInMinutes")
    private Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    @JsonProperty(value="properties.responseBasedAfdOriginErrorDetectionSettings")
    private ResponseBasedOriginErrorDetectionParameters responseBasedAfdOriginErrorDetectionSettings;
    @JsonProperty(value="properties.sessionAffinityState")
    private EnabledState sessionAffinityState;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private AfdProvisioningState provisioningState;
    @JsonProperty(value="properties.deploymentStatus", access=JsonProperty.Access.WRITE_ONLY)
    private DeploymentStatus deploymentStatus;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public LoadBalancingSettingsParameters loadBalancingSettings() {
        return this.loadBalancingSettings;
    }

    public AfdOriginGroupInner withLoadBalancingSettings(LoadBalancingSettingsParameters loadBalancingSettings) {
        this.loadBalancingSettings = loadBalancingSettings;
        return this;
    }

    public HealthProbeParameters healthProbeSettings() {
        return this.healthProbeSettings;
    }

    public AfdOriginGroupInner withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        this.healthProbeSettings = healthProbeSettings;
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
    }

    public AfdOriginGroupInner withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        this.trafficRestorationTimeToHealedOrNewEndpointsInMinutes = trafficRestorationTimeToHealedOrNewEndpointsInMinutes;
        return this;
    }

    public ResponseBasedOriginErrorDetectionParameters responseBasedAfdOriginErrorDetectionSettings() {
        return this.responseBasedAfdOriginErrorDetectionSettings;
    }

    public AfdOriginGroupInner withResponseBasedAfdOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedAfdOriginErrorDetectionSettings) {
        this.responseBasedAfdOriginErrorDetectionSettings = responseBasedAfdOriginErrorDetectionSettings;
        return this;
    }

    public EnabledState sessionAffinityState() {
        return this.sessionAffinityState;
    }

    public AfdOriginGroupInner withSessionAffinityState(EnabledState sessionAffinityState) {
        this.sessionAffinityState = sessionAffinityState;
        return this;
    }

    public AfdProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public void validate() {
        if (this.loadBalancingSettings() != null) {
            this.loadBalancingSettings().validate();
        }
        if (this.healthProbeSettings() != null) {
            this.healthProbeSettings().validate();
        }
        if (this.responseBasedAfdOriginErrorDetectionSettings() != null) {
            this.responseBasedAfdOriginErrorDetectionSettings().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }
}

