// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.EnabledState;
import java.io.IOException;

/**
 * The JSON object containing endpoint update parameters.
 */
@Fluent
public class AfdEndpointPropertiesUpdateParameters implements JsonSerializable<AfdEndpointPropertiesUpdateParameters> {
    /*
     * The name of the profile which holds the endpoint.
     */
    private String profileName;

    /*
     * Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    private EnabledState enabledState;

    /**
     * Creates an instance of AfdEndpointPropertiesUpdateParameters class.
     */
    public AfdEndpointPropertiesUpdateParameters() {
    }

    /**
     * Get the profileName property: The name of the profile which holds the endpoint.
     * 
     * @return the profileName value.
     */
    public String profileName() {
        return this.profileName;
    }

    /**
     * Set the profileName property: The name of the profile which holds the endpoint.
     * 
     * @param profileName the profileName value to set.
     * @return the AfdEndpointPropertiesUpdateParameters object itself.
     */
    AfdEndpointPropertiesUpdateParameters withProfileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    /**
     * Get the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     * 
     * @return the enabledState value.
     */
    public EnabledState enabledState() {
        return this.enabledState;
    }

    /**
     * Set the enabledState property: Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'.
     * 
     * @param enabledState the enabledState value to set.
     * @return the AfdEndpointPropertiesUpdateParameters object itself.
     */
    public AfdEndpointPropertiesUpdateParameters withEnabledState(EnabledState enabledState) {
        this.enabledState = enabledState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("enabledState", this.enabledState == null ? null : this.enabledState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AfdEndpointPropertiesUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AfdEndpointPropertiesUpdateParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AfdEndpointPropertiesUpdateParameters.
     */
    public static AfdEndpointPropertiesUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AfdEndpointPropertiesUpdateParameters deserializedAfdEndpointPropertiesUpdateParameters
                = new AfdEndpointPropertiesUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("profileName".equals(fieldName)) {
                    deserializedAfdEndpointPropertiesUpdateParameters.profileName = reader.getString();
                } else if ("enabledState".equals(fieldName)) {
                    deserializedAfdEndpointPropertiesUpdateParameters.enabledState
                        = EnabledState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAfdEndpointPropertiesUpdateParameters;
        });
    }
}
