// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * CDN Ip address group.
 */
@Fluent
public final class IpAddressGroup implements JsonSerializable<IpAddressGroup> {
    /*
     * The delivery region of the ip address group
     */
    private String deliveryRegion;

    /*
     * The list of ip v4 addresses.
     */
    private List<CidrIpAddress> ipv4Addresses;

    /*
     * The list of ip v6 addresses.
     */
    private List<CidrIpAddress> ipv6Addresses;

    /**
     * Creates an instance of IpAddressGroup class.
     */
    public IpAddressGroup() {
    }

    /**
     * Get the deliveryRegion property: The delivery region of the ip address group.
     * 
     * @return the deliveryRegion value.
     */
    public String deliveryRegion() {
        return this.deliveryRegion;
    }

    /**
     * Set the deliveryRegion property: The delivery region of the ip address group.
     * 
     * @param deliveryRegion the deliveryRegion value to set.
     * @return the IpAddressGroup object itself.
     */
    public IpAddressGroup withDeliveryRegion(String deliveryRegion) {
        this.deliveryRegion = deliveryRegion;
        return this;
    }

    /**
     * Get the ipv4Addresses property: The list of ip v4 addresses.
     * 
     * @return the ipv4Addresses value.
     */
    public List<CidrIpAddress> ipv4Addresses() {
        return this.ipv4Addresses;
    }

    /**
     * Set the ipv4Addresses property: The list of ip v4 addresses.
     * 
     * @param ipv4Addresses the ipv4Addresses value to set.
     * @return the IpAddressGroup object itself.
     */
    public IpAddressGroup withIpv4Addresses(List<CidrIpAddress> ipv4Addresses) {
        this.ipv4Addresses = ipv4Addresses;
        return this;
    }

    /**
     * Get the ipv6Addresses property: The list of ip v6 addresses.
     * 
     * @return the ipv6Addresses value.
     */
    public List<CidrIpAddress> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    /**
     * Set the ipv6Addresses property: The list of ip v6 addresses.
     * 
     * @param ipv6Addresses the ipv6Addresses value to set.
     * @return the IpAddressGroup object itself.
     */
    public IpAddressGroup withIpv6Addresses(List<CidrIpAddress> ipv6Addresses) {
        this.ipv6Addresses = ipv6Addresses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipv4Addresses() != null) {
            ipv4Addresses().forEach(e -> e.validate());
        }
        if (ipv6Addresses() != null) {
            ipv6Addresses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deliveryRegion", this.deliveryRegion);
        jsonWriter.writeArrayField("ipv4Addresses", this.ipv4Addresses, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("ipv6Addresses", this.ipv6Addresses, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpAddressGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpAddressGroup if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the IpAddressGroup.
     */
    public static IpAddressGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpAddressGroup deserializedIpAddressGroup = new IpAddressGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("deliveryRegion".equals(fieldName)) {
                    deserializedIpAddressGroup.deliveryRegion = reader.getString();
                } else if ("ipv4Addresses".equals(fieldName)) {
                    List<CidrIpAddress> ipv4Addresses = reader.readArray(reader1 -> CidrIpAddress.fromJson(reader1));
                    deserializedIpAddressGroup.ipv4Addresses = ipv4Addresses;
                } else if ("ipv6Addresses".equals(fieldName)) {
                    List<CidrIpAddress> ipv6Addresses = reader.readArray(reader1 -> CidrIpAddress.fromJson(reader1));
                    deserializedIpAddressGroup.ipv6Addresses = ipv6Addresses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpAddressGroup;
        });
    }
}
