/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.ProfileProperties;
import com.azure.resourcemanager.cdn.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cdn.models.ProfileLogScrubbing;
import com.azure.resourcemanager.cdn.models.ProfileProvisioningState;
import com.azure.resourcemanager.cdn.models.ProfileResourceState;
import com.azure.resourcemanager.cdn.models.Sku;
import java.io.IOException;
import java.util.Map;

public final class ProfileInner
extends Resource {
    private Sku sku;
    private String kind;
    private ManagedServiceIdentity identity;
    private ProfileProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(ProfileInner.class);

    public Sku sku() {
        return this.sku;
    }

    public ProfileInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ProfileInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ProfileProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProfileResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public ProfileProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Map<String, String> extendedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().extendedProperties();
    }

    public String frontDoorId() {
        return this.innerProperties() == null ? null : this.innerProperties().frontDoorId();
    }

    public Integer originResponseTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().originResponseTimeoutSeconds();
    }

    public ProfileInner withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfileProperties();
        }
        this.innerProperties().withOriginResponseTimeoutSeconds(originResponseTimeoutSeconds);
        return this;
    }

    public ProfileLogScrubbing logScrubbing() {
        return this.innerProperties() == null ? null : this.innerProperties().logScrubbing();
    }

    public ProfileInner withLogScrubbing(ProfileLogScrubbing logScrubbing) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfileProperties();
        }
        this.innerProperties().withLogScrubbing(logScrubbing);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model ProfileInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ProfileInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProfileInner)((Object)jsonReader.readObject(reader -> {
            ProfileInner deserializedProfileInner = new ProfileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProfileInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProfileInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProfileInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedProfileInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedProfileInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedProfileInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedProfileInner.kind = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedProfileInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProfileInner.innerProperties = ProfileProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedProfileInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProfileInner;
        }));
    }
}

